/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.config;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class FeaturesConfig
extends ConfigBase {
    private static final ConcurrentHashMap<ResourceLocation, ConfigFeature> FEATURES = new ConcurrentHashMap();
    private static final Map<ResourceLocation, ConfigFeature> FEATURES_VIEW = Collections.unmodifiableMap(FEATURES);
    protected final String modid;

    public FeaturesConfig(String modid) {
        this.modid = modid;
    }

    public static @UnmodifiableView Map<ResourceLocation, ConfigFeature> getFeatures() {
        return FEATURES_VIEW;
    }

    public static boolean isFeatureEnabled(ResourceLocation id) {
        return FEATURES.containsKey(id) && FEATURES.get(id).get() != false;
    }

    @Nullable
    protected Boolean getFeatureOverride(ResourceLocation id) {
        String key = id.toString();
        Boolean override = null;
        for (IModInfo mod : ModList.get().getMods()) {
            Boolean flag;
            Map properties = mod.getModProperties();
            Object v = properties.get(key);
            if (!(v instanceof Boolean)) continue;
            override = flag = (Boolean)v;
        }
        return override;
    }

    protected ConfigFeature feature(boolean enabled, String name, String ... comment) {
        return new ConfigFeature(name, enabled, comment);
    }

    public String getName() {
        return "features";
    }

    public class ConfigFeature
    extends ConfigBase.ConfigBool
    implements ICondition {
        public static final MapCodec<ConfigFeature> CODEC = ResourceLocation.CODEC.comapFlatMap(id -> FEATURES.containsKey(id) ? DataResult.success((Object)((Object)FEATURES.get(id))) : DataResult.error(() -> "No config features with id [" + String.valueOf(id) + "] exists"), ConfigFeature::getId).fieldOf("feature");
        private final ResourceLocation id;
        @Nullable
        private final Boolean override;

        public ConfigFeature(String name, boolean def, String ... comment) {
            super((ConfigBase)FeaturesConfig.this, name, def, comment);
            this.id = ResourceLocation.fromNamespaceAndPath((String)FeaturesConfig.this.modid, (String)name);
            this.override = FeaturesConfig.this.getFeatureOverride(this.id);
            if (FEATURES.containsKey(this.id)) {
                throw new IllegalStateException("Config features with id [" + String.valueOf(this.id) + "] already registered");
            }
            FEATURES.put(this.id, this);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public ConfigFeature addAlias(String name) {
            FEATURES.put(ResourceLocation.fromNamespaceAndPath((String)FeaturesConfig.this.modid, (String)name), this);
            return this;
        }

        public Boolean get() {
            return this.override == null ? (Boolean)super.get() : this.override;
        }

        public boolean test(ICondition.IContext context) {
            return this.get();
        }

        public MapCodec<? extends ICondition> codec() {
            return CODEC;
        }
    }
}

