/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumoptionsapi.mixin.sodium;

import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import me.flashyreese.mods.reeses_sodium_options.client.gui.SodiumVideoOptionsScreen;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.BasicFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.SearchTextFieldComponent;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.Tab;
import me.flashyreese.mods.reeses_sodium_options.compat.IrisCompat;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import toni.sodiumoptionsapi.gui.SodiumOptionsTabFrame;
import toni.sodiumoptionsapi.util.IOptionGroupIdAccessor;
import toni.sodiumoptionsapi.util.PlatformUtil;

@Mixin(value={SodiumVideoOptionsScreen.class})
public class ReesesVideoOptionsScreenMixin {
    @Shadow
    @Final
    private static AtomicReference<Integer> tabFrameScrollBarOffset;
    @Shadow
    @Final
    private static AtomicReference<Integer> optionPageScrollBarOffset;
    @Shadow
    @Final
    private List<OptionPage> pages;
    @Shadow
    private SearchTextFieldComponent searchTextField;
    @Shadow
    @Final
    private static AtomicReference<Component> tabFrameSelectedTab;
    @Unique
    private static final ResourceLocation LOGO_LOCATION;
    @Unique
    private Dim2i sodiumOptionsAPI$logoDim;

    @Inject(method={"<init>(Lnet/minecraft/client/gui/screens/Screen;Ljava/util/List;)V"}, at={@At(value="RETURN")})
    private void inject$registerTextures(Screen prev, List pages, CallbackInfo ci) {
        Minecraft.getInstance().getTextureManager().register(LOGO_LOCATION, (AbstractTexture)new SimpleTexture(LOGO_LOCATION));
    }

    @Inject(method={"parentFrameBuilder"}, at={@At(value="RETURN")}, remap=false)
    private void setLogoDim(CallbackInfoReturnable<BasicFrame.Builder> cir, @Local(ordinal=1) Dim2i tabFrameDim) {
        int logoSizeOnScreen = 20;
        this.sodiumOptionsAPI$logoDim = new Dim2i(tabFrameDim.x(), tabFrameDim.getLimitY() + 25 - logoSizeOnScreen, logoSizeOnScreen, logoSizeOnScreen);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")})
    private void onRender(GuiGraphics gfx, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        SodiumVideoOptionsScreen ths = (SodiumVideoOptionsScreen)this;
        int color = ColorARGB.pack((int)115, (int)197, (int)95);
        gfx.setColor((float)ColorARGB.unpackRed((int)color) / 255.0f, (float)ColorARGB.unpackGreen((int)color) / 255.0f, (float)ColorARGB.unpackBlue((int)color) / 255.0f, 0.8f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        gfx.blit(LOGO_LOCATION, this.sodiumOptionsAPI$logoDim.x(), this.sodiumOptionsAPI$logoDim.y(), this.sodiumOptionsAPI$logoDim.width(), this.sodiumOptionsAPI$logoDim.height(), 0.0f, 0.0f, 256, 256, 256, 256);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        gfx.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Redirect(method={"parentBasicFrameBuilder"}, at=@At(value="INVOKE", ordinal=0, target="Lme/flashyreese/mods/reeses_sodium_options/client/gui/frame/BasicFrame$Builder;addChild(Ljava/util/function/Function;)Lme/flashyreese/mods/reeses_sodium_options/client/gui/frame/BasicFrame$Builder;"), remap=false)
    private BasicFrame.Builder tabFrameBuilder(BasicFrame.Builder instance, Function<Dim2i, AbstractWidget> function, @Local(ordinal=1, argsOnly=true) Dim2i tabFrameDim) {
        instance.addChild(parentDim -> SodiumOptionsTabFrame.createBuilder().setDimension(tabFrameDim).shouldRenderOutline(false).setTabSectionScrollBarOffset(tabFrameScrollBarOffset).setTabSectionSelectedTab(tabFrameSelectedTab).addTabs(tabs -> this.pages.stream().filter(this::sodiumOptionsAPI$isSodiumTab).forEach(page -> tabs.put((Object)((IOptionGroupIdAccessor)page).sodiumOptionsAPI$getId().getModId(), (Object)Tab.builder().from(page, optionPageScrollBarOffset)))).addTabs(this::sodiumOptionsAPI$createShaderPackButton).addTabs(tabs -> this.pages.stream().filter(tab -> !this.sodiumOptionsAPI$isSodiumTab((OptionPage)tab)).forEach(page -> tabs.put((Object)((IOptionGroupIdAccessor)page).sodiumOptionsAPI$getId().getModId(), (Object)Tab.builder().from(page, optionPageScrollBarOffset)))).onSetTab(() -> optionPageScrollBarOffset.set(0)).build());
        return instance;
    }

    @Unique
    private boolean sodiumOptionsAPI$isSodiumTab(OptionPage optionPage) {
        if (optionPage.getName().getString().equals("Shader Packs...") || optionPage.getName().getString().equals("Oculus")) {
            return false;
        }
        return Objects.equals(((IOptionGroupIdAccessor)optionPage).sodiumOptionsAPI$getId().getModId(), "sodium") || Objects.equals(((IOptionGroupIdAccessor)optionPage).sodiumOptionsAPI$getId().getModId(), "embeddium");
    }

    @Unique
    private void sodiumOptionsAPI$createShaderPackButton(Multimap<String, Tab<?>> tabs) {
        boolean iris = IrisCompat.isIrisPresent();
        if (iris) {
            String shaderModId = Stream.of("oculus", "iris").filter(PlatformUtil::modPresent).findFirst().orElse("iris");
            Tab.Builder builder = Tab.builder().withTitle((Component)Component.translatable((String)"options.iris.shaderPackSelection")).withFrameFunction(this::sodiumOptionsAPI$getFrame);
            tabs.put((Object)shaderModId, (Object)builder.build());
        }
    }

    @Unique
    private <T extends AbstractFrame> T sodiumOptionsAPI$getFrame(Dim2i dim) {
        return (T)new BasicFrame(dim, false, new ArrayList());
    }

    static {
        LOGO_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"sodiumoptionsapi", (String)"textures/sodiumoptionsapi/gui/logo_transparent.png");
    }
}

