/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.LibGuiCommon;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WCardPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class WTabPanel
extends WPanel {
    private static final int TAB_PADDING = 4;
    private static final int TAB_WIDTH = 28;
    private static final int TAB_HEIGHT = 30;
    private static final int ICON_SIZE = 16;
    private final WBox tabRibbon = new WBox(Axis.HORIZONTAL).setSpacing(1);
    private final List<WTab> tabWidgets = new ArrayList<WTab>();
    private final Map<Tab, WTab> tabWidgetsByData = new HashMap<Tab, WTab>();
    private final WCardPanel mainPanel = new WCardPanel();

    public WTabPanel() {
        this.add(this.tabRibbon, 0, 0);
        this.add(this.mainPanel, 0, 30);
    }

    private void add(WWidget widget, int x, int y) {
        this.children.add(widget);
        widget.setParent(this);
        widget.setLocation(x, y);
        this.expandToFit(widget);
    }

    public void add(Tab tab) {
        WTab tabWidget = new WTab(tab);
        if (this.tabWidgets.isEmpty()) {
            tabWidget.selected = true;
        }
        this.tabWidgets.add(tabWidget);
        this.tabWidgetsByData.put(tab, tabWidget);
        this.tabRibbon.add(tabWidget, 28, 34);
        this.mainPanel.add(tab.getWidget());
    }

    public void add(WWidget widget, Consumer<Tab.Builder> configurator) {
        Tab.Builder builder = new Tab.Builder(widget);
        configurator.accept(builder);
        this.add(builder.build());
    }

    public Tab getSelectedTab() {
        return ((WTab)this.mainPanel.getSelectedCard()).data;
    }

    @Contract(value="null -> fail; _ -> this")
    public WTabPanel setSelectedTab(Tab tab) {
        Objects.requireNonNull(tab, "tab");
        WTab widget = this.tabWidgetsByData.get(tab);
        if (widget == null) {
            throw new NoSuchElementException("Trying to select unknown tab " + String.valueOf(tab));
        }
        return this.setSelectedIndex(this.tabWidgets.indexOf(widget));
    }

    public int getSelectedIndex() {
        return this.mainPanel.getSelectedIndex();
    }

    @Contract(value="_ -> this")
    public WTabPanel setSelectedIndex(int tabIndex) {
        this.mainPanel.setSelectedIndex(tabIndex);
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.tabWidgets.get((int)i).selected = i == tabIndex;
        }
        this.layout();
        return this;
    }

    public int getTabCount() {
        return this.tabWidgets.size();
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.tabRibbon.setSize(x, 30);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addPainters() {
        super.addPainters();
        this.mainPanel.setBackgroundPainter(BackgroundPainter.VANILLA);
    }

    private final class WTab
    extends WWidget {
        private final Tab data;
        boolean selected = false;

        WTab(Tab data) {
            this.data = data;
        }

        @Override
        public boolean canResize() {
            return true;
        }

        @Override
        public boolean canFocus() {
            return true;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public InputResult onClick(int x, int y, int button) {
            super.onClick(x, y, button);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            WTabPanel.this.setSelectedIndex(WTabPanel.this.tabWidgets.indexOf(this));
            return InputResult.PROCESSED;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public InputResult onKeyPressed(int ch, int key, int modifiers) {
            if (WTab.isActivationKey(ch)) {
                this.onClick(0, 0, 0);
                return InputResult.PROCESSED;
            }
            return InputResult.IGNORED;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
            class_327 renderer = class_310.method_1551().field_1772;
            class_2561 title = this.data.getTitle();
            Icon icon = this.data.getIcon();
            if (title != null) {
                int width = 28 + renderer.method_27525((class_5348)title);
                if (icon == null) {
                    width = Math.max(28, width - 16);
                }
                if (this.width != width) {
                    this.setSize(width, this.height);
                    this.getParent().layout();
                }
            }
            (this.selected ? Painters.SELECTED_TAB : Painters.UNSELECTED_TAB).paintBackground(context, x, y, this);
            if (this.isFocused()) {
                (this.selected ? Painters.SELECTED_TAB_FOCUS_BORDER : Painters.UNSELECTED_TAB_FOCUS_BORDER).paintBackground(context, x, y, this);
            }
            int iconX = 6;
            if (title != null) {
                HorizontalAlignment align;
                int titleX = icon != null ? iconX + 16 + 1 : 0;
                Objects.requireNonNull(renderer);
                int titleY = (this.height - 4 - 9) / 2 + 1;
                int width = icon != null ? this.width - iconX - 16 : this.width;
                HorizontalAlignment horizontalAlignment = align = icon != null ? HorizontalAlignment.LEFT : HorizontalAlignment.CENTER;
                int color = this.shouldRenderInDarkMode() ? 0xBCBCBC : (this.selected ? 0x404040 : 0xEEEEEE);
                ScreenDrawing.drawString(context, title.method_30937(), align, x + titleX, y + titleY, width, color);
            }
            if (icon != null) {
                icon.paint(context, x + iconX, y + (this.height - 4 - 16) / 2, 16);
            }
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void addTooltip(TooltipBuilder tooltip) {
            this.data.addTooltip(tooltip);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void addNarrations(class_6382 builder) {
            class_2561 label = this.data.getTitle();
            if (label != null) {
                builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"widget.libgui.tab.narration.title", (Object[])new Object[]{label}));
            }
            builder.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"widget.libgui.tab.narration.position", (Object[])new Object[]{WTabPanel.this.tabWidgets.indexOf(this) + 1, WTabPanel.this.tabWidgets.size()}));
        }
    }

    public static class Tab {
        @Nullable
        private final class_2561 title;
        @Nullable
        private final Icon icon;
        private final WWidget widget;
        @Nullable
        private final Consumer<TooltipBuilder> tooltip;

        private Tab(@Nullable class_2561 title, @Nullable Icon icon, WWidget widget, @Nullable Consumer<TooltipBuilder> tooltip) {
            if (title == null && icon == null) {
                throw new IllegalArgumentException("A tab must have a title or an icon");
            }
            this.title = title;
            this.icon = icon;
            this.widget = Objects.requireNonNull(widget, "widget");
            this.tooltip = tooltip;
        }

        @Nullable
        public class_2561 getTitle() {
            return this.title;
        }

        @Nullable
        public Icon getIcon() {
            return this.icon;
        }

        public WWidget getWidget() {
            return this.widget;
        }

        @Environment(value=EnvType.CLIENT)
        public void addTooltip(TooltipBuilder tooltip) {
            if (this.tooltip != null) {
                this.tooltip.accept(tooltip);
            }
        }

        public static final class Builder {
            @Nullable
            private class_2561 title;
            @Nullable
            private Icon icon;
            private final WWidget widget;
            private final List<class_2561> tooltip = new ArrayList<class_2561>();

            public Builder(WWidget widget) {
                this.widget = Objects.requireNonNull(widget, "widget");
            }

            public Builder title(class_2561 title) {
                this.title = Objects.requireNonNull(title, "title");
                return this;
            }

            public Builder icon(Icon icon) {
                this.icon = Objects.requireNonNull(icon, "icon");
                return this;
            }

            public Builder tooltip(class_2561 ... lines) {
                Objects.requireNonNull(lines, "lines");
                Collections.addAll(this.tooltip, lines);
                return this;
            }

            public Builder tooltip(Collection<? extends class_2561> lines) {
                Objects.requireNonNull(lines, "lines");
                this.tooltip.addAll(lines);
                return this;
            }

            public Tab build() {
                Consumer<TooltipBuilder> tooltip = null;
                if (!this.tooltip.isEmpty()) {
                    tooltip = new Consumer<TooltipBuilder>(){

                        @Override
                        @Environment(value=EnvType.CLIENT)
                        public void accept(TooltipBuilder builder) {
                            builder.add(tooltip.toArray(new class_2561[0]));
                        }
                    };
                }
                return new Tab(this.title, this.icon, this.widget, tooltip);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    static final class Painters {
        static final BackgroundPainter SELECTED_TAB = BackgroundPainter.createLightDarkVariants(BackgroundPainter.createNinePatch(LibGuiCommon.id("textures/widget/tab/selected_light.png")).setTopPadding(2), BackgroundPainter.createNinePatch(LibGuiCommon.id("textures/widget/tab/selected_dark.png")).setTopPadding(2));
        static final BackgroundPainter UNSELECTED_TAB = BackgroundPainter.createLightDarkVariants(BackgroundPainter.createNinePatch(LibGuiCommon.id("textures/widget/tab/unselected_light.png")), BackgroundPainter.createNinePatch(LibGuiCommon.id("textures/widget/tab/unselected_dark.png")));
        static final BackgroundPainter SELECTED_TAB_FOCUS_BORDER = BackgroundPainter.createNinePatch(LibGuiCommon.id("textures/widget/tab/focus.png")).setTopPadding(2);
        static final BackgroundPainter UNSELECTED_TAB_FOCUS_BORDER = BackgroundPainter.createNinePatch(LibGuiCommon.id("textures/widget/tab/focus.png"));

        Painters() {
        }
    }
}

