/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncCurios;
import top.theillusivec4.curios.server.command.CurioArgumentType;

public class CuriosCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder curiosCommand = (LiteralArgumentBuilder)Commands.literal((String)"curios").requires(player -> player.hasPermission(2));
        curiosCommand.then(Commands.literal((String)"list").executes(context -> {
            HashMap<String, Set> map = new HashMap<String, Set>();
            for (Map.Entry<String, Set<String>> entry : CuriosSlotManager.SERVER.getModsFromSlots().entrySet()) {
                map.computeIfAbsent(entry.getKey(), k -> new HashSet()).addAll((Collection)entry.getValue());
            }
            for (Map.Entry<String, Set<String>> entry : CuriosEntityManager.SERVER.getModsFromSlots().entrySet()) {
                map.computeIfAbsent(entry.getKey(), k -> new HashSet()).addAll((Collection)entry.getValue());
            }
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)((String)entry.getKey() + " - " + String.join((CharSequence)", ", (Iterable)entry.getValue()))), false);
            }
            return 1;
        }));
        curiosCommand.then(Commands.literal((String)"replace").then(Commands.argument((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"with").then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)buildContext)).executes(context -> CuriosCommand.replaceItemForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), ItemArgument.getItem((CommandContext)context, (String)"item")))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.replaceItemForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), ItemArgument.getItem((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"))))))))));
        curiosCommand.then(Commands.literal((String)"set").then(Commands.argument((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> CuriosCommand.setSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), 1))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.setSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.literal((String)"add").then(Commands.argument((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> CuriosCommand.growSlotForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), 1))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.growSlotForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.literal((String)"remove").then(Commands.argument((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> CuriosCommand.shrinkSlotForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), 1))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.shrinkSlotForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.literal((String)"clear").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> CuriosCommand.clearSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), ""))).then(Commands.argument((String)"slot", (ArgumentType)CurioArgumentType.slot()).executes(context -> CuriosCommand.clearSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"))))));
        curiosCommand.then(Commands.literal((String)"drop").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> CuriosCommand.dropSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), ""))).then(Commands.argument((String)"slot", (ArgumentType)CurioArgumentType.slot()).executes(context -> CuriosCommand.dropSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"))))));
        curiosCommand.then(Commands.literal((String)"reset").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> CuriosCommand.resetSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player")))));
        dispatcher.register(curiosCommand);
    }

    private static int replaceItemForPlayer(CommandSourceStack source, ServerPlayer player, String slot, int index, ItemInput item) throws CommandSyntaxException {
        return CuriosCommand.replaceItemForPlayer(source, player, slot, index, item, 1);
    }

    private static int replaceItemForPlayer(CommandSourceStack source, ServerPlayer player, String slot, int index, ItemInput item, int count) throws CommandSyntaxException {
        ItemStack stack = item.createItemStack(count, false);
        CuriosApi.getCuriosHelper().setEquippedCurio((LivingEntity)player, slot, index, stack);
        source.sendSuccess(() -> Component.translatable((String)"commands.curios.replace.success", (Object[])new Object[]{slot, player.getDisplayName(), stack.getDisplayName()}), true);
        return 1;
    }

    private static int setSlotsForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().setSlotsForType(slot, (LivingEntity)playerMP, amount);
        source.sendSuccess(() -> Component.translatable((String)"commands.curios.set.success", (Object[])new Object[]{slot, CuriosApi.getSlotHelper().getSlotsForType((LivingEntity)playerMP, slot), playerMP.getDisplayName()}), true);
        return 1;
    }

    private static int growSlotForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().growSlotType(slot, amount, (LivingEntity)playerMP);
        source.sendSuccess(() -> Component.translatable((String)"commands.curios.add.success", (Object[])new Object[]{amount, slot, playerMP.getDisplayName()}), true);
        return 1;
    }

    private static int shrinkSlotForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().shrinkSlotType(slot, amount, (LivingEntity)playerMP);
        source.sendSuccess(() -> Component.translatable((String)"commands.curios.remove.success", (Object[])new Object[]{amount, slot, playerMP.getDisplayName()}), true);
        return 1;
    }

    private static int dropSlotsForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            if (!slot.isEmpty() && curios.get(slot) != null) {
                CuriosCommand.drop(curios.get(slot), playerMP);
            } else {
                for (String id : curios.keySet()) {
                    CuriosCommand.drop(curios.get(id), playerMP);
                }
            }
        });
        if (slot.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"commands.curios.dropAll.success", (Object[])new Object[]{playerMP.getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.curios.drop.success", (Object[])new Object[]{slot, playerMP.getDisplayName()}), true);
        }
        return 1;
    }

    private static void drop(ICurioStacksHandler stacksHandler, ServerPlayer serverPlayer) {
        for (int i = 0; i < stacksHandler.getSlots(); ++i) {
            ItemStack stack1 = stacksHandler.getStacks().getStackInSlot(i);
            stacksHandler.getStacks().setStackInSlot(i, ItemStack.EMPTY);
            ItemStack stack2 = stacksHandler.getCosmeticStacks().getStackInSlot(i);
            stacksHandler.getCosmeticStacks().setStackInSlot(i, ItemStack.EMPTY);
            if (!stack1.isEmpty()) {
                serverPlayer.drop(stack1, true, false);
            }
            if (stack2.isEmpty()) continue;
            serverPlayer.drop(stack2, true, false);
        }
    }

    private static int clearSlotsForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            if (!slot.isEmpty() && curios.get(slot) != null) {
                CuriosCommand.clear(curios.get(slot));
            } else {
                for (String id : curios.keySet()) {
                    CuriosCommand.clear(curios.get(id));
                }
            }
        });
        if (slot.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"commands.curios.clearAll.success", (Object[])new Object[]{playerMP.getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.curios.clear.success", (Object[])new Object[]{slot, playerMP.getDisplayName()}), true);
        }
        return 1;
    }

    private static int resetSlotsForPlayer(CommandSourceStack source, ServerPlayer playerMP) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            handler.reset();
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)playerMP, (CustomPacketPayload)new SPacketSyncCurios(playerMP.getId(), handler.getCurios()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        source.sendSuccess(() -> Component.translatable((String)"commands.curios.reset.success", (Object[])new Object[]{playerMP.getDisplayName()}), true);
        return 1;
    }

    private static void clear(ICurioStacksHandler stacksHandler) {
        for (int i = 0; i < stacksHandler.getSlots(); ++i) {
            stacksHandler.getStacks().setStackInSlot(i, ItemStack.EMPTY);
            stacksHandler.getCosmeticStacks().setStackInSlot(i, ItemStack.EMPTY);
        }
    }
}

