/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;
import toni.sodiumdynamiclights.SodiumDynamicLights;
import toni.sodiumdynamiclights.accessor.DynamicLightHandlerHolder;

public final class DynamicLightHandlers {
    private DynamicLightHandlers() {
        throw new UnsupportedOperationException("DynamicLightHandlers only contains static definitions.");
    }

    public static void registerDefaultHandlers() {
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.BLAZE, DynamicLightHandler.makeHandler(blaze -> 10, blaze -> true));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.CREEPER, DynamicLightHandler.makeCreeperEntityHandler(null));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.ENDERMAN, (T entity) -> {
            int luminance = 0;
            if (entity.getCarriedBlock() != null) {
                luminance = entity.getCarriedBlock().getLightEmission();
            }
            return luminance;
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.ITEM, (T entity) -> SodiumDynamicLights.getLuminanceFromItemStack(entity.getItem(), entity.isUnderWater()));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.ITEM_FRAME, (T entity) -> {
            Level world = entity.level();
            return SodiumDynamicLights.getLuminanceFromItemStack(entity.getItem(), !world.getFluidState(entity.blockPosition()).isEmpty());
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.GLOW_ITEM_FRAME, (T entity) -> {
            Level world = entity.level();
            return Math.max(14, SodiumDynamicLights.getLuminanceFromItemStack(entity.getItem(), !world.getFluidState(entity.blockPosition()).isEmpty()));
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.MAGMA_CUBE, (T entity) -> (double)entity.squish > 0.6 ? 11 : 8);
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.SPECTRAL_ARROW, (T entity) -> 8);
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.GLOW_SQUID, (T entity) -> (int)Mth.clampedLerp((float)0.0f, (float)12.0f, (float)(1.0f - (float)entity.getDarkTicksRemaining() / 10.0f)));
    }

    public static <T extends Entity> void registerDynamicLightHandler(EntityType<T> type, DynamicLightHandler<T> handler) {
        DynamicLightHandlers.register((DynamicLightHandlerHolder)type, handler);
    }

    public static <T extends BlockEntity> void registerDynamicLightHandler(BlockEntityType<T> type, DynamicLightHandler<T> handler) {
        DynamicLightHandlers.register((DynamicLightHandlerHolder)type, handler);
    }

    private static <T> void register(DynamicLightHandlerHolder<T> holder, DynamicLightHandler<T> handler) {
        DynamicLightHandler registeredHandler = holder.sodiumdynamiclights$getDynamicLightHandler();
        if (registeredHandler != null) {
            DynamicLightHandler<Object> newHandler = entity -> Math.max(registeredHandler.getLuminance(entity), handler.getLuminance(entity));
            holder.sodiumdynamiclights$setDynamicLightHandler(newHandler);
        } else {
            holder.sodiumdynamiclights$setDynamicLightHandler(handler);
        }
    }

    @Nullable
    public static <T extends Entity> DynamicLightHandler<T> getDynamicLightHandler(EntityType<T> type) {
        return DynamicLightHandlerHolder.cast(type).sodiumdynamiclights$getDynamicLightHandler();
    }

    @Nullable
    public static <T extends BlockEntity> DynamicLightHandler<T> getDynamicLightHandler(BlockEntityType<T> type) {
        return DynamicLightHandlerHolder.cast(type).sodiumdynamiclights$getDynamicLightHandler();
    }

    public static <T extends Entity> boolean canLightUp(T entity) {
        if (entity == Minecraft.getInstance().player && !((Boolean)SodiumDynamicLights.get().config.getSelfLightSource().get()).booleanValue()) {
            return false;
        }
        boolean setting = DynamicLightHandlerHolder.cast(entity.getType()).sodiumdynamiclights$getSetting();
        return !setting;
    }

    public static <T extends BlockEntity> boolean canLightUp(T entity) {
        boolean setting = DynamicLightHandlerHolder.cast(entity.getType()).sodiumdynamiclights$getSetting();
        return !setting;
    }

    public static <T extends Entity> int getLuminanceFrom(T entity) {
        if (!((Boolean)SodiumDynamicLights.get().config.getEntitiesLightSource().get()).booleanValue()) {
            return 0;
        }
        if (entity == Minecraft.getInstance().player && !((Boolean)SodiumDynamicLights.get().config.getSelfLightSource().get()).booleanValue()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.getType());
        if (handler == null) {
            return 0;
        }
        if (!DynamicLightHandlers.canLightUp(entity)) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && !entity.level().getFluidState(BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ())).isEmpty()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }

    public static <T extends BlockEntity> int getLuminanceFrom(T entity) {
        if (!((Boolean)SodiumDynamicLights.get().config.getBlockEntitiesLightSource().get()).booleanValue()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.getType());
        if (handler == null) {
            return 0;
        }
        if (!DynamicLightHandlers.canLightUp(entity)) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && entity.getLevel() != null && !entity.getLevel().getFluidState(entity.getBlockPos()).isEmpty()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }
}

