/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders;

import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.itemborders.config.ItemBordersConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public class ItemBorders {
    public static final String MODID = "itemborders";
    public static final Logger LOGGER = LogManager.getLogger((String)"itemborders");

    public static void init() {
        ItemBordersConfig.register(ItemBordersConfig.class, (String)MODID);
    }

    public static void renderBorder(PoseStack poseStack, Slot slot) {
        ItemBorders.render(poseStack, slot.getItem(), slot.x, slot.y);
    }

    public static void renderBorder(PoseStack poseStack, ItemStack item, int x, int y) {
        if (ItemBordersConfig.getInstance().hotBar.get().booleanValue()) {
            ItemBorders.render(poseStack, item, x, y);
        }
    }

    private static void render(PoseStack poseStack, ItemStack item, int x, int y) {
        if (item.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        Pair borderColors = ItemBordersConfig.getInstance().getBorderColorForItem(item, (HolderLookup.Provider)minecraft.level.registryAccess());
        if (borderColors == null) {
            borderColors = new Pair(() -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE).getValue(), () -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE).getValue());
        }
        if (((Integer)((Supplier)borderColors.getFirst()).get() & 0xFFFFFF) == ChatFormatting.WHITE.getColor() && ((Integer)((Supplier)borderColors.getSecond()).get() & 0xFFFFFF) == ChatFormatting.WHITE.getColor() && !ItemBordersConfig.getInstance().showForCommon.get().booleanValue()) {
            return;
        }
        RenderSystem.disableDepthTest();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, ItemBordersConfig.getInstance().overItems.get() != false ? 290.0f : 100.0f);
        Matrix4f matrix = poseStack.last().pose();
        int startColor = (Integer)((Supplier)borderColors.getFirst()).get() & 0xFFFFFF;
        int endColor = (Integer)((Supplier)borderColors.getSecond()).get() & 0xFFFFFF;
        int topColor = ItemBordersConfig.getInstance().fullBorder.get() != false ? startColor | 0xEE000000 : startColor;
        int bottomColor = endColor | 0xEE000000;
        int xOffset = ItemBordersConfig.getInstance().squareCorners.get() != false ? 0 : 1;
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + 15), (int)topColor, (int)bottomColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 15), (int)(y + 1), (int)(x + 16), (int)(y + 15), (int)topColor, (int)bottomColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + xOffset), (int)y, (int)(x + 16 - xOffset), (int)(y + 1), (int)topColor, (int)topColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + xOffset), (int)(y + 15), (int)(x + 16 - xOffset), (int)(y + 16), (int)bottomColor, (int)bottomColor);
        if (ItemBordersConfig.getInstance().extraGlow.get().booleanValue()) {
            int topAlpha = (topColor >> 24 & 0xFF) / 3;
            int bottomAlpha = (bottomColor >> 24 & 0xFF) / 3;
            int topGlowColor = topAlpha << 24 | topColor & 0xFFFFFF;
            int bottomGlowColor = bottomAlpha << 24 | bottomColor & 0xFFFFFF;
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 1), (int)(y + 1), (int)(x + 2), (int)(y + 15), (int)topGlowColor, (int)bottomGlowColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 14), (int)(y + 1), (int)(x + 15), (int)(y + 15), (int)topGlowColor, (int)bottomGlowColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 1), (int)(y + 1), (int)(x + 15), (int)(y + 2), (int)topGlowColor, (int)topGlowColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 1), (int)(y + 14), (int)(x + 15), (int)(y + 15), (int)bottomGlowColor, (int)bottomGlowColor);
        }
        poseStack.popPose();
    }
}

