/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders.config;

import com.anthonyhilyard.iceberg.config.IcebergConfig;
import com.anthonyhilyard.iceberg.services.IIcebergConfigSpecBuilder;
import com.anthonyhilyard.iceberg.services.Services;
import com.anthonyhilyard.iceberg.util.Selectors;
import com.anthonyhilyard.prism.item.ItemColors;
import com.anthonyhilyard.prism.util.ConfigHelper;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class ItemBordersConfig
extends IcebergConfig<ItemBordersConfig> {
    public final Supplier<Boolean> hotBar;
    public final Supplier<Boolean> showForCommon;
    public final Supplier<Boolean> squareCorners;
    public final Supplier<Boolean> fullBorder;
    public final Supplier<Boolean> overItems;
    public final Supplier<Boolean> extraGlow;
    public final Supplier<Boolean> automaticBorders;
    public final Supplier<Boolean> legendaryTooltipsSync;
    private final Supplier<Map<String, Object>> manualBorders;
    private Map<ItemKey, Pair<Supplier<Integer>, Supplier<Integer>>> cachedCustomBorders = Maps.newHashMap();
    private boolean emptyCache = true;

    public static ItemBordersConfig getInstance() {
        return (ItemBordersConfig)((Object)configInstances.get("itemborders"));
    }

    public ItemBordersConfig(IIcebergConfigSpecBuilder build) {
        int i;
        build.comment(" If you would like to specify manual borders, add a new manual_borders section at the bottom of the file.\n The format for each color of border is 'color = [\"modid:item1\", \"modid:item2\"]\"]'. Replace the color with either a color name (like red or blue), or a RGB / ARGB hex color code like 0xFFFFFF or 0xFF00FFFF.\n Here is a sample you can copy / paste and edit as needed:\n[client.options.manual_borders]\n\tred = [\"minecraft:torch\", \"minecraft:stick\"]").push("client").push("options");
        this.hotBar = build.comment(" If the hotbar should display item borders.").add("hotbar", true);
        this.showForCommon = build.comment(" If item borders should show for common items.").add("show_for_common", false);
        this.squareCorners = build.comment(" If the borders should have square corners.").add("square_corners", true);
        this.fullBorder = build.comment(" If the borders should fully envelop item slots (otherwise they will only show on the bottom portion of the slot).").add("full_border", false);
        this.overItems = build.comment(" If the borders draw over items instead of under.").add("over_items", false);
        this.extraGlow = build.comment(" If the borders should have a more prominent glow.").add("extra_glow", false);
        this.automaticBorders = build.comment(" If automatic borders (based on item rarity) should be enabled.").add("auto_borders", true);
        this.legendaryTooltipsSync = build.comment(" If enabled and Legendary Tooltips is installed, borders will sync with tooltip border colors.").add("legendary_tooltips_sync", false);
        StringBuilder entriesComment = new StringBuilder(" Custom border colors for specific items. Format: { <color> = [\"list of selectors\"] }.\n Color formats supported:\n");
        for (ConfigHelper.ColorFormatDocumentation doc : ConfigHelper.colorFormatDocumentation((boolean)true)) {
            entriesComment.append("   ").append(doc.name()).append(" - ").append(doc.description().replace("\n\n", "\n").replace("\n", "\n     "));
            if (!doc.examples().isEmpty()) {
                entriesComment.append("  Examples: ");
                for (i = 0; i < doc.examples().size(); ++i) {
                    if (((String)doc.examples().get(0)).startsWith("Using")) {
                        if (i == 0) {
                            entriesComment.setLength(entriesComment.length() - 18);
                            entriesComment.append("  ");
                        }
                        if (i > 1) {
                            entriesComment.append(", ");
                        }
                        entriesComment.append((String)doc.examples().get(i));
                        if (i != 0) continue;
                        entriesComment.append("     Examples: ");
                        continue;
                    }
                    if (i > 0) {
                        entriesComment.append(", ");
                    }
                    entriesComment.append((String)doc.examples().get(i));
                }
            }
            entriesComment.append("\n");
        }
        entriesComment.append(" Selectors supported:\n");
        for (ConfigHelper.ColorFormatDocumentation doc : Selectors.selectorDocumentation()) {
            entriesComment.append("   ").append(doc.name()).append(" - ").append(doc.description());
            if (!doc.examples().isEmpty()) {
                entriesComment.append("  Examples: ");
                for (i = 0; i < doc.examples().size(); ++i) {
                    if (i > 0) {
                        entriesComment.append(", ");
                    }
                    entriesComment.append("\"").append((String)doc.examples().get(i)).append("\"");
                }
            }
            entriesComment.append("\n");
        }
        entriesComment.setLength(entriesComment.length() - 1);
        this.manualBorders = build.comment(entriesComment.toString()).addSubconfig("manual_borders", Map.of(), k -> ItemBordersConfig.validateColor(k), v -> v instanceof List);
        build.pop().pop();
    }

    protected void onReload() {
        this.emptyCache = true;
    }

    public static TextColor getColor(Object value) {
        return (TextColor)ConfigHelper.parseColor((Object)value);
    }

    private static boolean validateColor(Object value) {
        return ItemBordersConfig.getColor(value) != null;
    }

    public Pair<Supplier<Integer>, Supplier<Integer>> getBorderColorForItem(ItemStack item, HolderLookup.Provider provider) {
        CompoundTag tag;
        ItemKey itemKey = new ItemKey(item.getItem(), (DataComponentMap)new PatchedDataComponentMap(item.getComponents()));
        if (this.emptyCache) {
            this.emptyCache = false;
            this.cachedCustomBorders.clear();
        }
        if (this.cachedCustomBorders.containsKey(itemKey)) {
            return this.cachedCustomBorders.get(itemKey);
        }
        Map<String, Object> manualBorderMap = this.manualBorders.get();
        for (String key : manualBorderMap.keySet()) {
            TextColor color = ItemBordersConfig.getColor(key);
            Pair colors = new Pair(() -> color.getValue(), () -> color.getValue());
            if (color == null) continue;
            Object value = manualBorderMap.get(key);
            if (value instanceof String) {
                if (!Selectors.itemMatches((ItemStack)item, (String)((String)value), (HolderLookup.Provider)provider)) continue;
                this.cachedCustomBorders.put(itemKey, (Pair<Supplier<Integer>, Supplier<Integer>>)colors);
                return colors;
            }
            if (!(value instanceof List)) continue;
            List valueList = (List)value;
            for (Object stringVal : valueList) {
                if (!(stringVal instanceof String) || !Selectors.itemMatches((ItemStack)item, (String)((String)stringVal), (HolderLookup.Provider)provider)) continue;
                this.cachedCustomBorders.put(itemKey, (Pair<Supplier<Integer>, Supplier<Integer>>)colors);
                return colors;
            }
        }
        Pair colors = null;
        if (item.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)item.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("itemborders_colors")) {
            CompoundTag colorsTag = tag.getCompound("itemborders_colors");
            TextColor topColor = null;
            TextColor bottomColor = null;
            if (colorsTag.contains("top")) {
                topColor = ItemBordersConfig.getColor(colorsTag.get("top").getAsString());
            }
            if (colorsTag.contains("bottom")) {
                bottomColor = ItemBordersConfig.getColor(colorsTag.get("bottom").getAsString());
            }
            if (topColor == null) {
                topColor = bottomColor;
            }
            if (bottomColor == null) {
                bottomColor = topColor;
            }
            if (topColor != null && bottomColor != null) {
                TextColor finalTopColor = topColor;
                TextColor finalBottomColor = bottomColor;
                colors = new Pair(() -> finalTopColor.getValue(), () -> finalBottomColor.getValue());
                this.cachedCustomBorders.put(itemKey, (Pair<Supplier<Integer>, Supplier<Integer>>)colors);
                return colors;
            }
        }
        if (ItemBordersConfig.getInstance().automaticBorders.get().booleanValue()) {
            TextColor color = ItemColors.getColorForItem((ItemStack)item, null);
            colors = new Pair(() -> color.getValue(), () -> color.getValue());
        }
        if (Services.getPlatformHelper().isModLoaded("legendarytooltips") && ItemBordersConfig.getInstance().legendaryTooltipsSync.get().booleanValue()) {
            Pair borderColors = null;
            try {
                borderColors = (Pair)Class.forName("com.anthonyhilyard.itemborders.compat.LegendaryTooltipsHandler").getMethod("getBorderColors", ItemStack.class).invoke(null, item);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (borderColors != null) {
                colors = borderColors;
            }
        }
        this.cachedCustomBorders.put(itemKey, colors);
        return colors;
    }

    private record ItemKey(Item item, DataComponentMap components) {
    }
}

