/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternRepository;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class PatternRepositoryImpl
implements PatternRepository {
    private final Set<Pattern> patterns = new HashSet<Pattern>();
    private final Set<Pattern> patternsView = Collections.unmodifiableSet(this.patterns);
    private final Map<ResourceKey, PriorityQueue<PatternHolder>> patternsByOutput = new HashMap<ResourceKey, PriorityQueue<PatternHolder>>();
    private final Set<ResourceKey> outputs = new HashSet<ResourceKey>();
    private final Set<ResourceKey> outputsView = Collections.unmodifiableSet(this.outputs);

    @Override
    public void add(Pattern pattern, int priority) {
        this.patterns.add(pattern);
        pattern.layout().outputs().forEach(output -> this.outputs.add(output.resource()));
        for (ResourceAmount output2 : pattern.layout().outputs()) {
            this.patternsByOutput.computeIfAbsent(output2.resource(), k -> new PriorityQueue<PatternHolder>(Comparator.comparingInt(PatternHolder::priority).reversed())).add(new PatternHolder(pattern, priority));
        }
    }

    @Override
    public void update(Pattern pattern, int priority) {
        for (ResourceAmount output : pattern.layout().outputs()) {
            PriorityQueue<PatternHolder> holders = this.patternsByOutput.get(output.resource());
            if (holders == null) continue;
            holders.removeIf(holder -> holder.pattern.equals(pattern));
            holders.add(new PatternHolder(pattern, priority));
        }
    }

    @Override
    public void remove(Pattern pattern) {
        this.patterns.remove(pattern);
        for (ResourceAmount output : pattern.layout().outputs()) {
            boolean noOtherPatternHasThisOutput;
            PriorityQueue<PatternHolder> holders = this.patternsByOutput.get(output.resource());
            if (holders == null) continue;
            holders.removeIf(holder -> holder.pattern.equals(pattern));
            if (holders.isEmpty()) {
                this.patternsByOutput.remove(output.resource());
            }
            if (!(noOtherPatternHasThisOutput = this.patterns.stream().noneMatch(otherPattern -> otherPattern.layout().outputs().stream().anyMatch(o -> o.resource().equals(output.resource()))))) continue;
            this.outputs.remove(output.resource());
        }
    }

    public List<Pattern> getByOutput(ResourceKey output) {
        PriorityQueue<PatternHolder> holders = this.patternsByOutput.get(output);
        if (holders == null) {
            return Collections.emptyList();
        }
        return holders.stream().map(holder -> holder.pattern).toList();
    }

    @Override
    public Set<ResourceKey> getOutputs() {
        return this.outputsView;
    }

    @Override
    public Set<Pattern> getAll() {
        return this.patternsView;
    }

    private record PatternHolder(Pattern pattern, int priority) {
    }
}

