/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.relay;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.ParentContainer;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayOutputPatternProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayOutputStorage;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.network.security.SecurityActor;
import com.refinedmods.refinedstorage.api.network.security.SecurityDecision;
import com.refinedmods.refinedstorage.api.network.security.SecurityDecisionProvider;
import com.refinedmods.refinedstorage.api.network.security.SecurityNetworkComponent;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.network.storage.StorageProvider;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.api.storage.Storage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public class RelayOutputNetworkNode
extends AbstractNetworkNode
implements EnergyProvider,
SecurityDecisionProvider,
StorageProvider,
PatternProvider {
    private final long energyUsage;
    private final RelayOutputStorage storage = new RelayOutputStorage();
    private final RelayOutputPatternProvider patternProvider = new RelayOutputPatternProvider(this);
    @Nullable
    private EnergyNetworkComponent energyDelegate;
    @Nullable
    private SecurityNetworkComponent securityDelegate;

    public RelayOutputNetworkNode(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    void setEnergyDelegate(@Nullable EnergyNetworkComponent energyDelegate) {
        this.energyDelegate = energyDelegate;
    }

    void setSecurityDelegate(@Nullable SecurityNetworkComponent securityDelegate) {
        this.securityDelegate = securityDelegate;
    }

    void setStorageDelegate(@Nullable StorageNetworkComponent storageDelegate) {
        this.storage.setDelegate(storageDelegate);
    }

    void setAutocraftingDelegate(@Nullable AutocraftingNetworkComponent autocraftingDelegate) {
        this.patternProvider.setDelegate(autocraftingDelegate);
    }

    void setAccessMode(AccessMode accessMode) {
        this.storage.setAccessMode(accessMode);
    }

    void setInsertPriority(int insertPriority) {
        this.storage.setInsertPriority(insertPriority);
        if (this.network != null) {
            this.network.getComponent(StorageNetworkComponent.class).sortSources();
        }
    }

    void setExtractPriority(int extractPriority) {
        this.storage.setExtractPriority(extractPriority);
        if (this.network != null) {
            this.network.getComponent(StorageNetworkComponent.class).sortSources();
        }
    }

    void setFilters(Set<ResourceKey> filters) {
        this.storage.setFilters(filters);
        this.patternProvider.setFilters(filters);
    }

    void setFilterMode(FilterMode filterMode) {
        this.storage.setFilterMode(filterMode);
        this.patternProvider.setFilterMode(filterMode);
    }

    void setFilterNormalizer(UnaryOperator<ResourceKey> normalizer) {
        this.storage.setFilterNormalizer(normalizer);
        this.patternProvider.setFilterNormalizer(normalizer);
    }

    @Override
    public long getEnergyUsage() {
        if (this.energyDelegate != null || this.securityDelegate != null || this.storage.hasDelegate() || this.patternProvider.hasDelegate()) {
            return this.energyUsage;
        }
        return 0L;
    }

    @Override
    public void doWork() {
        super.doWork();
        this.patternProvider.doWork();
    }

    public void setStepBehavior(StepBehavior stepBehavior) {
        this.patternProvider.setStepBehavior(stepBehavior);
    }

    @Override
    public long getStored() {
        return this.energyDelegate == null || this.energyDelegate.contains(this.energyDelegate) ? 0L : this.energyDelegate.getStored();
    }

    @Override
    public long getCapacity() {
        return this.energyDelegate == null || this.energyDelegate.contains(this.energyDelegate) ? 0L : this.energyDelegate.getCapacity();
    }

    @Override
    public long extract(long amount) {
        return this.energyDelegate == null || this.energyDelegate.contains(this.energyDelegate) ? 0L : this.energyDelegate.extract(amount);
    }

    @Override
    public boolean contains(EnergyProvider energyProvider) {
        return energyProvider == this.energyDelegate || this.energyDelegate != null && this.energyDelegate.contains(energyProvider);
    }

    @Override
    public boolean contains(SecurityNetworkComponent securityComponent) {
        return securityComponent == this.securityDelegate || this.securityDelegate != null && this.securityDelegate.contains(securityComponent);
    }

    @Override
    public boolean contains(AutocraftingNetworkComponent component) {
        return this.patternProvider.contains(component);
    }

    public List<Task> getTasks() {
        return this.patternProvider.getTasks();
    }

    @Override
    public void addTask(Task task) {
        this.patternProvider.addTask(task);
    }

    @Override
    public void cancelTask(TaskId taskId) {
        this.patternProvider.cancelTask(taskId);
    }

    @Override
    public List<TaskStatus> getTaskStatuses() {
        return this.patternProvider.getTaskStatuses();
    }

    @Override
    public long getAmount(ResourceKey resource) {
        return this.patternProvider.getAmount(resource);
    }

    @Override
    public void receivedExternalIteration() {
        this.patternProvider.receivedExternalIteration();
    }

    @Override
    public SecurityDecision isAllowed(Permission permission, SecurityActor actor) {
        if (this.securityDelegate == null || this.securityDelegate.contains(this.securityDelegate)) {
            return SecurityDecision.PASS;
        }
        return this.securityDelegate.isAllowed(permission, actor) ? SecurityDecision.ALLOW : SecurityDecision.DENY;
    }

    @Override
    public boolean isProviderActive() {
        return this.isActive() && this.securityDelegate != null;
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public void onAddedIntoContainer(ParentContainer parentContainer) {
        this.patternProvider.onAddedIntoContainer(parentContainer);
    }

    @Override
    public void onRemovedFromContainer(ParentContainer parentContainer) {
        this.patternProvider.onRemovedFromContainer(parentContainer);
    }

    @Override
    public ExternalPatternSink.Result accept(Pattern pattern, Collection<ResourceAmount> resources, Action action) {
        return this.patternProvider.accept(pattern, resources, action);
    }

    @Override
    public void setNetwork(@Nullable Network network) {
        if (this.network != null) {
            this.patternProvider.detachAll(this.network);
        }
        super.setNetwork(network);
        if (network != null) {
            this.patternProvider.attachAll(network);
        }
    }
}

