/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.exporter;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.BlockEntityProvider;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.exporter.AbstractExporterBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalCableBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.DirectionalCableBlockShapes;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExporterBlock
extends AbstractDirectionalCableBlock
implements ColorableBlock<ExporterBlock, BaseBlockItem>,
EntityBlock,
BlockItemProvider<BaseBlockItem> {
    private static final Component HELP = IdentifierUtil.createTranslation("item", "exporter.help");
    private static final ConcurrentHashMap<AbstractDirectionalCableBlock.DirectionalCacheShapeCacheKey, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap();
    private static final AbstractBlockEntityTicker<AbstractExporterBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(BlockEntities.INSTANCE::getExporter);
    private final DyeColor color;
    private final MutableComponent name;
    private final BlockEntityProvider<AbstractExporterBlockEntity> blockEntityProvider;

    public ExporterBlock(DyeColor color, MutableComponent name, BlockEntityProvider<AbstractExporterBlockEntity> blockEntityProvider) {
        super(SHAPE_CACHE);
        this.color = color;
        this.name = name;
        this.blockEntityProvider = blockEntityProvider;
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityProvider.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return TICKER.get(level, type);
    }

    @Override
    public BlockColorMap<ExporterBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getExporter();
    }

    @Override
    protected VoxelShape getExtensionShape(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> DirectionalCableBlockShapes.EXPORTER_NORTH;
            case Direction.EAST -> DirectionalCableBlockShapes.EXPORTER_EAST;
            case Direction.SOUTH -> DirectionalCableBlockShapes.EXPORTER_SOUTH;
            case Direction.WEST -> DirectionalCableBlockShapes.EXPORTER_WEST;
            case Direction.UP -> DirectionalCableBlockShapes.EXPORTER_UP;
            case Direction.DOWN -> DirectionalCableBlockShapes.EXPORTER_DOWN;
        };
    }

    public MutableComponent getName() {
        return this.name;
    }

    @Override
    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem(this, HELP);
    }
}

