/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.view;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.api.grid.GridResourceAttributeKeys;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.view.FluidGridResource;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.material.Fluid;

public abstract class AbstractFluidGridResourceRepositoryMapper
implements ResourceRepositoryMapper<GridResource> {
    @Override
    public GridResource apply(ResourceKey resource) {
        FluidResource fluidResource = (FluidResource)resource;
        String name = this.getName(fluidResource);
        String modId = this.getModId(fluidResource);
        String modName = this.getModName(modId);
        Map<GridResourceAttributeKeys, Supplier> attributes = Map.of(GridResourceAttributeKeys.MOD_ID, Suppliers.ofInstance(Set.of(modId)), GridResourceAttributeKeys.MOD_NAME, Suppliers.ofInstance(Set.of(modName)), GridResourceAttributeKeys.TAGS, Suppliers.ofInstance(this.getTags(fluidResource.fluid())), GridResourceAttributeKeys.TOOLTIP, Suppliers.ofInstance(Set.of(this.getTooltip(fluidResource))));
        return new FluidGridResource(fluidResource, name, k -> attributes.getOrDefault(k, Collections::emptySet).get());
    }

    private Set<String> getTags(Fluid fluid) {
        return BuiltInRegistries.FLUID.getResourceKey((Object)fluid).flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getHolder(arg_0)).stream().flatMap(Holder::tags).map(tagKey -> tagKey.location().getPath()).collect(Collectors.toSet());
    }

    private String getModId(FluidResource fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid.fluid()).getNamespace();
    }

    protected abstract String getModName(String var1);

    protected abstract String getName(FluidResource var1);

    protected abstract String getTooltip(FluidResource var1);
}

