/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemPlayerValidator;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterBlockEntity;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterConnectionStrategy;
import com.refinedmods.refinedstorage.common.support.network.InWorldNetworkNodeContainerImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

class WirelessTransmitterNetworkNodeContainer
extends InWorldNetworkNodeContainerImpl
implements NetworkItemPlayerValidator {
    private final WirelessTransmitterBlockEntity blockEntity;
    private final AbstractNetworkNode node;

    WirelessTransmitterNetworkNodeContainer(WirelessTransmitterBlockEntity blockEntity, AbstractNetworkNode node, String name, WirelessTransmitterConnectionStrategy connectionStrategy) {
        super(blockEntity, node, name, 0, connectionStrategy, null);
        this.blockEntity = blockEntity;
        this.node = node;
    }

    @Override
    public boolean isValid(NetworkItemPlayerValidator.PlayerCoordinates coordinates) {
        Level level = this.blockEntity.getLevel();
        if (level == null || level.dimension() != coordinates.dimension()) {
            return false;
        }
        if (!this.node.isActive()) {
            return false;
        }
        BlockPos pos = this.blockEntity.getBlockPos();
        Vec3 playerPos = coordinates.position();
        double distance = Math.sqrt(Math.pow((double)pos.getX() - playerPos.x(), 2.0) + Math.pow((double)pos.getY() - playerPos.y(), 2.0) + Math.pow((double)pos.getZ() - playerPos.z(), 2.0));
        return distance <= (double)this.blockEntity.getRange();
    }
}

