/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.amount;

import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.joml.Vector3f;

public final class AmountScreenConfiguration<T extends Number> {
    private static final MutableComponent SET_TEXT = IdentifierUtil.createTranslation("gui", "configure_amount.set");
    @Nullable
    private final T initialAmount;
    private final int[] incrementsTop;
    private final Vector3f incrementsTopStartPosition;
    private final int[] incrementsBottom;
    private final Vector3f incrementsBottomStartPosition;
    private final int amountFieldWidth;
    private final Vector3f amountFieldPosition;
    private final Vector3f actionButtonsStartPosition;
    private final boolean horizontalActionButtons;
    private final boolean actionButtonsEnabled;
    private final Component confirmButtonText;
    @Nullable
    private final Supplier<T> minAmount;
    @Nullable
    private final T maxAmount;
    @Nullable
    private final T resetAmount;

    private AmountScreenConfiguration(@Nullable T initialAmount, int[] incrementsTop, Vector3f incrementsTopStartPosition, int[] incrementsBottom, Vector3f incrementsBottomStartPosition, int amountFieldWidth, Vector3f amountFieldPosition, Vector3f actionButtonsStartPosition, boolean horizontalActionButtons, boolean actionButtonsEnabled, Component confirmButtonText, @Nullable Supplier<T> minAmount, @Nullable T maxAmount, @Nullable T resetAmount) {
        this.initialAmount = initialAmount;
        this.incrementsTop = incrementsTop;
        this.incrementsTopStartPosition = incrementsTopStartPosition;
        this.incrementsBottom = incrementsBottom;
        this.incrementsBottomStartPosition = incrementsBottomStartPosition;
        this.amountFieldWidth = amountFieldWidth;
        this.amountFieldPosition = amountFieldPosition;
        this.actionButtonsStartPosition = actionButtonsStartPosition;
        this.horizontalActionButtons = horizontalActionButtons;
        this.actionButtonsEnabled = actionButtonsEnabled;
        this.confirmButtonText = confirmButtonText;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.resetAmount = resetAmount;
    }

    @Nullable
    public T getInitialAmount() {
        return this.initialAmount;
    }

    public int[] getIncrementsTop() {
        return this.incrementsTop;
    }

    public Vector3f getIncrementsTopStartPosition() {
        return this.incrementsTopStartPosition;
    }

    public int[] getIncrementsBottom() {
        return this.incrementsBottom;
    }

    public Vector3f getIncrementsBottomStartPosition() {
        return this.incrementsBottomStartPosition;
    }

    public int getAmountFieldWidth() {
        return this.amountFieldWidth;
    }

    public Vector3f getAmountFieldPosition() {
        return this.amountFieldPosition;
    }

    public Vector3f getActionButtonsStartPosition() {
        return this.actionButtonsStartPosition;
    }

    public boolean isHorizontalActionButtons() {
        return this.horizontalActionButtons;
    }

    public boolean isActionButtonsEnabled() {
        return this.actionButtonsEnabled;
    }

    public Component getConfirmButtonText() {
        return this.confirmButtonText;
    }

    @Nullable
    public T getMinAmount() {
        return (T)(this.minAmount != null ? (Number)((Number)this.minAmount.get()) : (Number)null);
    }

    @Nullable
    public T getMaxAmount() {
        return this.maxAmount;
    }

    @Nullable
    public T getResetAmount() {
        return this.resetAmount;
    }

    public static final class AmountScreenConfigurationBuilder<T extends Number> {
        @Nullable
        private T initialAmount;
        private int[] incrementsTop = new int[0];
        private Vector3f incrementsTopStartPosition = new Vector3f(7.0f, 20.0f, 0.0f);
        private int[] incrementsBottom = new int[0];
        private Vector3f incrementsBottomStartPosition = new Vector3f(7.0f, 67.0f, 0.0f);
        private int amountFieldWidth = 68;
        private Vector3f amountFieldPosition = new Vector3f(0.0f, 0.0f, 0.0f);
        private Vector3f actionButtonsStartPosition = new Vector3f(0.0f, 0.0f, 0.0f);
        private boolean horizontalActionButtons = false;
        private Component confirmButtonText = SET_TEXT;
        private boolean actionButtonsEnabled = true;
        @Nullable
        private Supplier<T> minAmount;
        @Nullable
        private T maxAmount;
        @Nullable
        private T resetAmount;

        private AmountScreenConfigurationBuilder() {
        }

        public static <T extends Number> AmountScreenConfigurationBuilder<T> create() {
            return new AmountScreenConfigurationBuilder<T>();
        }

        public AmountScreenConfigurationBuilder<T> withInitialAmount(T newInitialAmount) {
            this.initialAmount = newInitialAmount;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withIncrementsTop(int ... newIncrementsTop) {
            this.incrementsTop = newIncrementsTop;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withIncrementsTopStartPosition(Vector3f newPos) {
            this.incrementsTopStartPosition = newPos;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withIncrementsBottom(int ... newIncrementsBottom) {
            this.incrementsBottom = newIncrementsBottom;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withIncrementsBottomStartPosition(Vector3f newPos) {
            this.incrementsBottomStartPosition = newPos;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withAmountFieldWidth(int newAmountFieldWidth) {
            this.amountFieldWidth = newAmountFieldWidth;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withAmountFieldPosition(Vector3f newAmountFieldPosition) {
            this.amountFieldPosition = newAmountFieldPosition;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withActionButtonsStartPosition(Vector3f newActionButtonsStartPosition) {
            this.actionButtonsStartPosition = newActionButtonsStartPosition;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withHorizontalActionButtons(boolean newHorizontalActionButtons) {
            this.horizontalActionButtons = newHorizontalActionButtons;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withConfirmButtonText(Component newConfirmButtonText) {
            this.confirmButtonText = newConfirmButtonText;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withActionButtonsEnabled(boolean newActionButtonsEnabled) {
            this.actionButtonsEnabled = newActionButtonsEnabled;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withMinAmount(Supplier<T> newMinAmount) {
            this.minAmount = newMinAmount;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withMaxAmount(T newMaxAmount) {
            this.maxAmount = newMaxAmount;
            return this;
        }

        public AmountScreenConfigurationBuilder<T> withResetAmount(T newResetAmount) {
            this.resetAmount = newResetAmount;
            return this;
        }

        public AmountScreenConfiguration<T> build() {
            return new AmountScreenConfiguration<T>(this.initialAmount, this.incrementsTop, this.incrementsTopStartPosition, this.incrementsBottom, this.incrementsBottomStartPosition, this.amountFieldWidth, this.amountFieldPosition, this.actionButtonsStartPosition, this.horizontalActionButtons, this.actionButtonsEnabled, this.confirmButtonText, this.minAmount, this.maxAmount, this.resetAmount);
        }
    }
}

