/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.tooltip;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ResourceClientTooltipComponent
implements ClientTooltipComponent {
    private final ResourceAmount resourceAmount;
    private final Component name;

    public ResourceClientTooltipComponent(ResourceAmount resourceAmount) {
        this.resourceAmount = resourceAmount;
        this.name = ResourceClientTooltipComponent.getNameWithAmount(resourceAmount);
    }

    public int getHeight() {
        return 18;
    }

    public int getWidth(Font font) {
        return 20 + font.width((FormattedText)this.name);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        RefinedStorageClientApi.INSTANCE.getResourceRendering(this.resourceAmount.resource().getClass()).render(this.resourceAmount.resource(), graphics, x, y);
        graphics.drawString(font, this.name, x + 16 + 4, y + 4, 0xAAAAAA);
    }

    private static Component getNameWithAmount(ResourceAmount resourceAmount) {
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resourceAmount.resource().getClass());
        String amount = rendering.formatAmount(resourceAmount.amount());
        Component displayName = rendering.getDisplayName(resourceAmount.resource());
        return displayName.copy().append(" (").append(amount).append(")");
    }
}

