/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.grid.strategy;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.neoforge.grid.strategy.CursorItemHandler;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.storage.ItemHandlerExtractableStorage;
import com.refinedmods.refinedstorage.neoforge.storage.ItemHandlerInsertableStorage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class ItemGridScrollingStrategy
implements GridScrollingStrategy {
    private final GridOperations gridOperations;
    private final Inventory playerInventory;
    private final PlayerMainInvWrapper playerInventoryStorage;
    private final CursorItemHandler playerCursorItemHandler;

    public ItemGridScrollingStrategy(AbstractContainerMenu containerMenu, ServerPlayer player, Grid grid) {
        this.gridOperations = grid.createOperations(ResourceTypes.ITEM, player);
        this.playerInventory = player.getInventory();
        this.playerInventoryStorage = new PlayerMainInvWrapper(this.playerInventory);
        this.playerCursorItemHandler = new CursorItemHandler(containerMenu);
    }

    @Override
    public boolean onScroll(PlatformResourceKey resource, GridScrollMode scrollMode, int slotIndex) {
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            RangedWrapper playerStorage = slotIndex >= 0 ? new RangedWrapper((IItemHandlerModifiable)new InvWrapper((Container)this.playerInventory), slotIndex, slotIndex + 1) : this.playerInventoryStorage;
            switch (scrollMode) {
                case GRID_TO_INVENTORY: {
                    this.handleGridToInventoryScroll(itemResource, (IItemHandler)playerStorage);
                    break;
                }
                case INVENTORY_TO_GRID: {
                    this.handleInventoryToGridScroll(itemResource, (IItemHandler)playerStorage);
                    break;
                }
                case GRID_TO_CURSOR: {
                    this.handleGridToInventoryScroll(itemResource, this.playerCursorItemHandler);
                }
            }
            return true;
        }
        return false;
    }

    private void handleInventoryToGridScroll(ItemResource itemResource, IItemHandler sourceStorage) {
        this.gridOperations.insert(itemResource, GridInsertMode.SINGLE_RESOURCE, new ItemHandlerExtractableStorage(CapabilityCache.ofItemHandler(sourceStorage)));
    }

    private void handleGridToInventoryScroll(ItemResource itemResource, IItemHandler destinationStorage) {
        this.gridOperations.extract(itemResource, GridExtractMode.SINGLE_RESOURCE, new ItemHandlerInsertableStorage(CapabilityCache.ofItemHandler(destinationStorage)));
    }
}

