/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage.portablegrid;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlock;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockItem;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockItemRenderInfo;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.neoforge.storage.portablegrid.DiskLedBakers;
import com.refinedmods.refinedstorage.neoforge.storage.portablegrid.ForgePortableGridBlockEntity;
import com.refinedmods.refinedstorage.neoforge.support.render.DiskModelBaker;
import com.refinedmods.refinedstorage.neoforge.support.render.ItemBakedModel;
import com.refinedmods.refinedstorage.neoforge.support.render.RotationTranslationModelBaker;
import com.refinedmods.refinedstorage.neoforge.support.render.TransformationBuilder;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector3f;

class PortableGridBakedModel
extends BakedModelWrapper<BakedModel> {
    private static final Vector3f MOVE_TO_DISK_LOCATION = new Vector3f(0.0f, -0.75f, 0.5625f);
    private static final Vector3f MOVE_TO_DISK_LED_LOCATION = new Vector3f(0.0f, -0.75f, 0.5625f);
    private final LoadingCache<CacheKey, List<BakedQuad>> cache;
    private final PortableGridItemOverrides itemOverrides = new PortableGridItemOverrides();

    PortableGridBakedModel(BakedModel baseModel, RotationTranslationModelBaker activeModelBaker, RotationTranslationModelBaker inactiveModelBaker, DiskModelBaker diskModelBaker, DiskLedBakers diskLedBakers) {
        super(baseModel);
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.from(cacheKey -> {
            RotationTranslationModelBaker baseModelBaker = cacheKey.active ? activeModelBaker : inactiveModelBaker;
            List<BakedQuad> quads = baseModelBaker.bake(TransformationBuilder.create().rotate(cacheKey.direction).build(), cacheKey.side(), RandomSource.create());
            if (cacheKey.disk.item() == null) {
                return quads;
            }
            RotationTranslationModelBaker diskBaker = diskModelBaker.forDisk(cacheKey.disk.item());
            if (diskBaker != null) {
                quads.addAll(diskBaker.bake(TransformationBuilder.create().rotate(cacheKey.direction).translate(MOVE_TO_DISK_LOCATION).rotate(BiDirection.WEST).build(), cacheKey.side(), RandomSource.create()));
            }
            if (cacheKey.includeLed && cacheKey.disk.state() != StorageState.NONE) {
                quads.addAll(diskLedBakers.forState(cacheKey.disk.state()).bake(TransformationBuilder.create().translate(MOVE_TO_DISK_LED_LOCATION).rotate(BiDirection.WEST).build(), cacheKey.side(), RandomSource.create()));
            }
            return quads;
        }));
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource randomSource, ModelData extraData, @Nullable RenderType renderType) {
        Block block;
        if (state == null || !((block = state.getBlock()) instanceof PortableGridBlock)) {
            return super.getQuads(state, side, randomSource);
        }
        PortableGridBlock portableGridBlock = (PortableGridBlock)block;
        BiDirection direction = (BiDirection)((Object)portableGridBlock.getDirection(state));
        if (direction == null) {
            return super.getQuads(state, side, randomSource);
        }
        Disk disk = (Disk)extraData.get(ForgePortableGridBlockEntity.DISK_PROPERTY);
        if (disk == null) {
            return super.getQuads(state, side, randomSource);
        }
        boolean active = (Boolean)state.getValue((Property)PortableGridBlock.ACTIVE);
        return (List)this.cache.getUnchecked((Object)new CacheKey(side, direction, active, disk, false));
    }

    public ItemOverrides getOverrides() {
        return this.itemOverrides;
    }

    private class PortableGridItemOverrides
    extends ItemOverrides {
        private final LoadingCache<CacheKey, BakedModel> itemCache = CacheBuilder.newBuilder().build(CacheLoader.from(cacheKey -> new ItemBakedModel(PortableGridBakedModel.this.originalModel, (List)PortableGridBakedModel.this.cache.getUnchecked(cacheKey), Collections.emptyMap())));

        private PortableGridItemOverrides() {
        }

        @Nullable
        public BakedModel resolve(BakedModel bakedModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            if (level == null) {
                return null;
            }
            PortableGridBlockItemRenderInfo renderInfo = PortableGridBlockItem.getRenderInfo(stack, (Level)level);
            return (BakedModel)this.itemCache.getUnchecked((Object)new CacheKey(null, BiDirection.NORTH, renderInfo.active(), renderInfo.disk(), true));
        }
    }

    private record CacheKey(@Nullable Direction side, BiDirection direction, boolean active, Disk disk, boolean includeLed) {
    }
}

