/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Sizing;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateFeature
implements MarkdownFeature {
    public String name() {
        return "block_states";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<block;")) {
                return false;
            }
            String blockStateString = nibbler.consumeUntil('>');
            if (blockStateString == null) {
                return false;
            }
            try {
                tokens.add(new BlockStateToken(blockStateString, BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)blockStateString, (boolean)true)));
                return true;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, stateToken, tokens) -> new BlockStateNode(stateToken.state), (token, tokens) -> {
            BlockStateToken blockState;
            return token instanceof BlockStateToken ? (blockState = (BlockStateToken)((Object)token)) : null;
        });
    }

    private static class BlockStateToken
    extends Lexer.Token {
        public final BlockStateParser.BlockResult state;

        public BlockStateToken(String content, BlockStateParser.BlockResult state) {
            super(content);
            this.state = state;
        }
    }

    private static class BlockStateNode
    extends Parser.Node {
        private final BlockStateParser.BlockResult state;

        public BlockStateNode(BlockStateParser.BlockResult state) {
            this.state = state;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            ((OwoUICompiler)compiler).visitComponent((Component)Containers.stack((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).child(Components.block((BlockState)this.state.blockState(), (CompoundTag)this.state.nbt()).sizing(Sizing.fixed((int)48))).horizontalAlignment(HorizontalAlignment.CENTER));
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

