/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.core.Component;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStackFeature
implements MarkdownFeature {
    private final HolderLookup.Provider registries;

    public ItemStackFeature(HolderLookup.Provider registries) {
        this.registries = registries;
    }

    public String name() {
        return "item_stacks";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<item;")) {
                return false;
            }
            String itemStackString = nibbler.consumeUntil('>');
            if (itemStackString == null) {
                return false;
            }
            try {
                ItemParser.ItemResult result = new ItemParser(this.registries).parse(new StringReader(itemStackString));
                ItemStack stack = ((Item)result.item().value()).getDefaultInstance();
                stack.applyComponents(result.components());
                tokens.add(new ItemStackToken(itemStackString, stack));
                return true;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, stackToken, tokens) -> new ItemStackNode(stackToken.stack), (token, tokens) -> {
            ItemStackToken itemStack;
            return token instanceof ItemStackToken ? (itemStack = (ItemStackToken)((Object)token)) : null;
        });
    }

    private static class ItemStackToken
    extends Lexer.Token {
        public final ItemStack stack;

        public ItemStackToken(String content, ItemStack stack) {
            super(content);
            this.stack = stack;
        }
    }

    private static class ItemStackNode
    extends Parser.Node {
        private final ItemStack stack;

        public ItemStackNode(ItemStack stack) {
            this.stack = stack;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            ((OwoUICompiler)compiler).visitComponent((Component)Components.item((ItemStack)this.stack).setTooltipFromStack(true));
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

