/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.necro.raid.dens.common.CobblemonRaidDensClient;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.blocks.model.RaidCrystalBlockModel;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

@OnlyIn(value=Dist.CLIENT)
public class RaidCrystalRenderer
extends GeoBlockRenderer<RaidCrystalBlockEntity> {
    public static final ResourceLocation BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png");

    public RaidCrystalRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new RaidCrystalBlockModel());
    }

    public void actuallyRender(PoseStack poseStack, RaidCrystalBlockEntity blockEntity, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource multiBufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float f, int i, int j, int colour) {
        if (RaidCrystalRenderer.shouldRenderBeacon(blockEntity) && blockEntity.renderBeacon(blockEntity.getBlockState()) && blockEntity.getLevel() != null && RaidUtils.hasSkyAccess((LevelReader)blockEntity.getLevel(), blockEntity.getBlockPos().above())) {
            poseStack.pushPose();
            poseStack.scale(0.75f, 1.0f, 0.75f);
            poseStack.translate(-0.5, 0.0, -0.5);
            BeaconRenderer.renderBeaconBeam((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (ResourceLocation)BEAM_LOCATION, (float)f, (float)1.0f, (long)blockEntity.getLevel().getGameTime(), (int)0, (int)1024, (int)((RaidType)((Object)blockEntity.getBlockState().getValue(RaidCrystalBlock.RAID_TYPE))).getColor(), (float)0.2f, (float)0.25f);
            poseStack.popPose();
        }
        super.actuallyRender(poseStack, (BlockEntity)blockEntity, model, renderType, multiBufferSource, buffer, isReRender, f, i, j, colour);
    }

    public boolean shouldRenderOffScreen(RaidCrystalBlockEntity blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRender(RaidCrystalBlockEntity blockEntity, Vec3 vec3) {
        return Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)vec3.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    private static boolean shouldRenderBeacon(RaidCrystalBlockEntity blockEntity) {
        return switch ((RaidTier)((Object)blockEntity.getBlockState().getValue(RaidCrystalBlock.RAID_TIER))) {
            default -> throw new MatchException(null, null);
            case RaidTier.TIER_ONE -> CobblemonRaidDensClient.CLIENT_CONFIG.show_beam_tier_one;
            case RaidTier.TIER_TWO -> CobblemonRaidDensClient.CLIENT_CONFIG.show_beam_tier_two;
            case RaidTier.TIER_THREE -> CobblemonRaidDensClient.CLIENT_CONFIG.show_beam_tier_three;
            case RaidTier.TIER_FOUR -> CobblemonRaidDensClient.CLIENT_CONFIG.show_beam_tier_four;
            case RaidTier.TIER_FIVE -> CobblemonRaidDensClient.CLIENT_CONFIG.show_beam_tier_five;
            case RaidTier.TIER_SIX -> CobblemonRaidDensClient.CLIENT_CONFIG.show_beam_tier_six;
            case RaidTier.TIER_SEVEN -> CobblemonRaidDensClient.CLIENT_CONFIG.show_beam_tier_seven;
        };
    }
}

