/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.network.packets;

import com.necro.raid.dens.common.client.gui.RaidDenGuiManager;
import com.necro.raid.dens.common.network.ClientPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record RaidLogPacket(String pokemon, String move) implements CustomPacketPayload,
ClientPacket
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_log");
    public static final CustomPacketPayload.Type<RaidLogPacket> PACKET_TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, RaidLogPacket> CODEC = StreamCodec.ofMember(RaidLogPacket::write, RaidLogPacket::read);

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.pokemon);
        buf.writeUtf(this.move);
    }

    public static RaidLogPacket read(FriendlyByteBuf buf) {
        return new RaidLogPacket(buf.readUtf(), buf.readUtf());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    @Override
    public void handleClient() {
        if (RaidDenGuiManager.RAID_OVERLAY == null) {
            return;
        }
        MutableComponent log = Component.translatable((String)"battle.cobblemonraiddens.log.used_move", (Object[])new Object[]{Component.translatable((String)this.pokemon), Component.translatable((String)this.move)});
        RaidDenGuiManager.RAID_OVERLAY.addLog((Component)log);
    }
}

