/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.highlighter;

import com.anthonyhilyard.highlighter.config.HighlighterConfig;
import com.anthonyhilyard.iceberg.events.client.ItemTooltipEvent;
import com.anthonyhilyard.iceberg.events.client.NewItemPickupEvent;
import com.anthonyhilyard.iceberg.util.Easing;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Highlighter {
    public static final String MODID = "highlighter";
    public static final Logger LOGGER = LogManager.getLogger((String)"highlighter");
    public static final ResourceLocation NEW_ITEM_MARKS = ResourceLocation.fromNamespaceAndPath((String)"highlighter", (String)"textures/gui/newitemmarks.png");
    private static Set<Integer> markedSlots = new HashSet<Integer>(36);

    public static void init() {
        HighlighterConfig.register(HighlighterConfig.class, (String)MODID);
        NewItemPickupEvent.EVENT.register(Highlighter::newItemPickup);
        ItemTooltipEvent.EVENT.register(Highlighter::onItemTooltip);
    }

    public static void newItemPickup(UUID uuid, ItemStack itemStack) {
        Minecraft mc = Minecraft.getInstance();
        Player player = mc.level.getPlayerByUUID(uuid);
        if (player != null && player.equals((Object)mc.player)) {
            Highlighter.handlePreItemPickup(player, itemStack);
        }
    }

    private static void handlePreItemPickup(Player player, ItemStack item) {
        int slot = player.getInventory().getSlotWithRemainingSpace(item);
        if (slot == -1) {
            slot = player.getInventory().getFreeSlot();
        }
        if (slot != -1) {
            markedSlots.add(slot);
        }
    }

    public static void clearMark(int slotIndex) {
        markedSlots.remove(slotIndex);
    }

    public static void itemClicked(int slotIndex) {
        Highlighter.clearMark(slotIndex);
    }

    public static void inventoryClosed() {
        if (HighlighterConfig.getInstance().clearOnInventoryClose.get().booleanValue()) {
            markedSlots.clear();
        }
    }

    public static void onItemTooltip(ItemStack stack, Item.TooltipContext context, TooltipFlag flag, List<Component> lines) {
        if (HighlighterConfig.getInstance().clearOnHover.get().booleanValue()) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.screen != null && mc.screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen invScreen = (AbstractContainerScreen)mc.screen;
                Slot slot = invScreen.hoveredSlot;
                if (slot != null && slot.getItem() == stack) {
                    Highlighter.clearMark(slot.getContainerSlot());
                }
            }
        }
    }

    public static void renderNewItemMark(PoseStack poseStack, Slot slot) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.player.isCreative()) {
            if (markedSlots.contains(slot.getContainerSlot()) && slot.hasItem()) {
                Highlighter.render(poseStack, slot.getItem(), slot.x, slot.y);
            } else {
                Highlighter.clearMark(slot.getContainerSlot());
            }
        }
    }

    public static void renderHotBarItemMark(int slotIndex, PoseStack poseStack, ItemStack item, int x, int y) {
        if (!HighlighterConfig.getInstance().showOnHotbar.get().booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (!mc.player.isCreative() && markedSlots.contains(slotIndex)) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, -100.0f);
            Highlighter.render(poseStack, item, x, y);
            poseStack.popPose();
        }
    }

    private static void render(PoseStack poseStack, ItemStack item, int x, int y) {
        if (item.isEmpty()) {
            return;
        }
        float timeOffset = Math.abs((float)(Util.getMillis() % 2000L) / 1000.0f - 1.0f);
        TextColor color = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE);
        if (HighlighterConfig.getInstance().useItemNameColor.get().booleanValue()) {
            color = HighlighterConfig.getColorForItem(item, color);
        }
        RenderSystem.disableDepthTest();
        poseStack.pushPose();
        poseStack.translate(0.0f, -Easing.Ease((float)0.0f, (float)1.0f, (float)timeOffset), 410.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NEW_ITEM_MARKS);
        RenderSystem.setShaderColor((float)((float)(color.getValue() >> 16 & 0xFF) / 255.0f), (float)((float)(color.getValue() >> 8 & 0xFF) / 255.0f), (float)((float)(color.getValue() & 0xFF) / 255.0f), (float)1.0f);
        switch (HighlighterConfig.getInstance().iconPosition.get()) {
            default: {
                break;
            }
            case UpperRight: {
                x += 8;
                break;
            }
            case LowerLeft: {
                y += 8;
                break;
            }
            case LowerRight: {
                x += 8;
                y += 8;
            }
        }
        GuiHelper.blit((PoseStack)poseStack, (int)x, (int)y, (int)8, (int)8, (float)(HighlighterConfig.getInstance().useItemNameColor.get() != false ? 8.0f : 0.0f), (float)0.0f, (int)8, (int)8, (int)16, (int)16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }
}

