/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.impl;

import java.util.function.Function;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.exception.CrosshairContextChange;
import mod.crend.dynamiccrosshairapi.internal.ContextedApi;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class ContextedApiImpl
implements ContextedApi {
    private final CrosshairContext context;

    public ContextedApiImpl(CrosshairContext context) {
        this.context = context;
    }

    public boolean test(Function<DynamicCrosshairApi, Boolean> lambda) {
        for (DynamicCrosshairApi api : this.context.apis()) {
            try {
                if (!lambda.apply(api).booleanValue()) continue;
                return true;
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                if (e instanceof CrosshairContextChange) {
                    throw e;
                }
                CrosshairHandler.LOGGER.error("Exception occurred during evaluation of API {}", (Object)api.getModId(), (Object)e);
            }
        }
        return false;
    }

    public boolean isAlwaysInteractable(BlockState blockState) {
        return this.test(api -> api.isAlwaysInteractable(blockState));
    }

    public boolean isAlwaysInteractableInCreativeMode(BlockState blockState) {
        return this.test(api -> api.isAlwaysInteractableInCreativeMode(blockState));
    }

    public boolean isInteractable(BlockState blockState) {
        return this.test(api -> api.isInteractable(blockState));
    }

    public boolean isAlwaysInteractable(EntityType<?> entityType) {
        return this.test(api -> api.isAlwaysInteractable(entityType));
    }

    public boolean isInteractable(EntityType<?> entityType) {
        return this.test(api -> api.isInteractable(entityType));
    }

    public boolean isAlwaysUsable(ItemStack itemStack) {
        return this.test(api -> api.isAlwaysUsable(itemStack));
    }

    public boolean isAlwaysUsableOnBlock(ItemStack itemStack) {
        return this.test(api -> api.isAlwaysUsableOnBlock(itemStack));
    }

    public boolean isAlwaysUsableOnEntity(ItemStack itemStack) {
        return this.test(api -> api.isAlwaysUsableOnEntity(itemStack));
    }

    public boolean isAlwaysUsableOnMiss(ItemStack itemStack) {
        return this.test(api -> api.isAlwaysUsableOnMiss(itemStack));
    }

    public boolean isUsable(ItemStack itemStack) {
        return this.test(api -> api.isUsable(itemStack));
    }

    public boolean isBlock(ItemStack itemStack) {
        return this.test(api -> api.isBlock(itemStack));
    }

    public boolean isMeleeWeapon(ItemStack itemStack) {
        return this.test(api -> api.isMeleeWeapon(itemStack));
    }

    public boolean isRangedWeapon(ItemStack itemStack) {
        return this.test(api -> api.isRangedWeapon(itemStack));
    }

    public boolean isShield(ItemStack itemStack) {
        return this.test(api -> api.isShield(itemStack));
    }

    public boolean isThrowable(ItemStack itemStack) {
        return this.test(api -> api.isThrowable(itemStack));
    }

    public boolean isTool(ItemStack itemStack) {
        return this.test(api -> api.isTool(itemStack));
    }
}

