/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin.block;

import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairBlock;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={AbstractCauldronBlock.class})
public abstract class AbstractCauldronBlockMixin
extends Block
implements DynamicCrosshairBlock {
    public AbstractCauldronBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        ItemStack handItemStack = context.getItemStack();
        Item handItem = handItemStack.getItem();
        if (handItem instanceof BucketItem) {
            return InteractionType.EMPTY;
        }
        if (handItem instanceof SolidBucketItem) {
            return InteractionType.FILL_BLOCK_FROM_ITEM;
        }
        if (((Object)((Object)this)).equals(Blocks.WATER_CAULDRON)) {
            BannerPatternLayers bannerPatternsComponent;
            ShulkerBoxBlock sbb;
            BlockItem blockItem;
            Block block;
            PotionContents potionContentsComponent;
            if (handItem instanceof BottleItem) {
                return InteractionType.FILL_ITEM_FROM_BLOCK;
            }
            if (handItem instanceof PotionItem && (potionContentsComponent = (PotionContents)handItemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER)) {
                return InteractionType.FILL_BLOCK_FROM_ITEM;
            }
            if (handItem instanceof BlockItem && (block = (blockItem = (BlockItem)handItem).getBlock()) instanceof ShulkerBoxBlock && (sbb = (ShulkerBoxBlock)block).getColor() != null) {
                return InteractionType.USE_ITEM_ON_BLOCK;
            }
            if (handItemStack.is(ItemTags.DYEABLE) && handItemStack.has(DataComponents.DYED_COLOR)) {
                return InteractionType.USE_ITEM_ON_BLOCK;
            }
            if (handItem instanceof BannerItem && !(bannerPatternsComponent = (BannerPatternLayers)handItemStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY)).layers().isEmpty()) {
                return InteractionType.USE_ITEM_ON_BLOCK;
            }
        }
        return InteractionType.NO_ACTION;
    }
}

