/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod;

import com.gitlab.srcmc.rctmod.advancements.criteria.DefeatCountTrigger;
import com.gitlab.srcmc.rctmod.commands.arguments.TokenArgumentType;
import com.gitlab.srcmc.rctmod.world.blocks.TrainerRepelRodBlock;
import com.gitlab.srcmc.rctmod.world.blocks.TrainerSpawnerBlock;
import com.gitlab.srcmc.rctmod.world.blocks.entities.TrainerSpawnerBlockEntity;
import com.gitlab.srcmc.rctmod.world.entities.TrainerAssociation;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.gitlab.srcmc.rctmod.world.items.TrainerCard;
import com.gitlab.srcmc.rctmod.world.loot.conditions.DefeatCountCondition;
import com.gitlab.srcmc.rctmod.world.loot.conditions.LevelRangeCondition;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class ModRegistries {
    private static boolean initialized;

    public static void init() {
        ModRegistries.init(false);
    }

    public static void init(boolean skipArgumentType) {
        if (!initialized) {
            if (!skipArgumentType) {
                ArgumentTypes.REGISTRY.register();
            }
            Entities.REGISTRY.register();
            Blocks.REGISTRY.register();
            Items.REGISTRY.register();
            BlockEntityTypes.REGISTRY.register();
            LootItemConditions.REGISTRY.register();
            CriteriaTriggers.REGISTRY.register();
            CreativeTabs.REGISTRY.register();
            EntityAttributeRegistry.register(Entities.TRAINER, TrainerMob::createAttributes);
            EntityAttributeRegistry.register(Entities.TRAINER_ASSOCIATION, TrainerAssociation::createAttributes);
            initialized = true;
        }
    }

    public static ResourceLocation location(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)key);
    }

    private ModRegistries() {
    }

    public class ArgumentTypes {
        public static final DeferredRegister<ArgumentTypeInfo<?, ?>> REGISTRY = DeferredRegister.create((String)"rctmod", (ResourceKey)Registries.COMMAND_ARGUMENT_TYPE);
        public static final RegistrySupplier<ArgumentTypeInfo<TokenArgumentType, ?>> TOKEN_ARGUMENT_TYPE = REGISTRY.register(ModRegistries.location("token_argument_type"), () -> SingletonArgumentInfo.contextFree(TokenArgumentType::token));

        public ArgumentTypes(ModRegistries this$0) {
        }
    }

    public class Entities {
        public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((String)"rctmod", (ResourceKey)Registries.ENTITY_TYPE);
        public static final RegistrySupplier<EntityType<TrainerMob>> TRAINER = REGISTRY.register(ModRegistries.location("trainer"), TrainerMob::getEntityType);
        public static final RegistrySupplier<EntityType<TrainerAssociation>> TRAINER_ASSOCIATION = REGISTRY.register(ModRegistries.location("trainer_association"), TrainerAssociation::getEntityType);

        public Entities(ModRegistries this$0) {
        }
    }

    public class Blocks {
        public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((String)"rctmod", (ResourceKey)Registries.BLOCK);
        public static final RegistrySupplier<TrainerSpawnerBlock> TRAINER_SPAWNER = REGISTRY.register(ModRegistries.location("trainer_spawner"), TrainerSpawnerBlock::new);
        public static final RegistrySupplier<TrainerRepelRodBlock> TRAINER_REPEL_ROD = REGISTRY.register(ModRegistries.location("trainer_repel_rod"), TrainerRepelRodBlock::new);

        public Blocks(ModRegistries this$0) {
        }
    }

    public class Items {
        public static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((String)"rctmod", (ResourceKey)Registries.ITEM);
        public static final RegistrySupplier<TrainerCard> TRAINER_CARD = REGISTRY.register(ModRegistries.location("trainer_card"), TrainerCard::new);
        public static final RegistrySupplier<BlockItem> TRAINER_SPAWNER = REGISTRY.register(ModRegistries.location("trainer_spawner"), () -> new BlockItem((Block)Blocks.TRAINER_SPAWNER.get(), new Item.Properties()));
        public static final RegistrySupplier<BlockItem> TRAINER_REPEL_ROD = REGISTRY.register(ModRegistries.location("trainer_repel_rod"), () -> new BlockItem((Block)Blocks.TRAINER_REPEL_ROD.get(), new Item.Properties()));

        public Items(ModRegistries this$0) {
        }
    }

    public class BlockEntityTypes {
        public static final DeferredRegister<BlockEntityType<?>> REGISTRY = DeferredRegister.create((String)"rctmod", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
        public static final RegistrySupplier<BlockEntityType<TrainerSpawnerBlockEntity>> TRAINER_SPAWNER = REGISTRY.register(ModRegistries.location("trainer_spawner"), () -> BlockEntityType.Builder.of(TrainerSpawnerBlockEntity::new, (Block[])new Block[]{(Block)Blocks.TRAINER_SPAWNER.get()}).build(null));

        public BlockEntityTypes(ModRegistries this$0) {
        }
    }

    public class LootItemConditions {
        public static final DeferredRegister<LootItemConditionType> REGISTRY = DeferredRegister.create((String)"rctmod", (ResourceKey)Registries.LOOT_CONDITION_TYPE);
        public static final RegistrySupplier<LootItemConditionType> LEVEL_RANGE = REGISTRY.register(ModRegistries.location("level_range"), () -> new LootItemConditionType(LevelRangeCondition.CODEC));
        public static final RegistrySupplier<LootItemConditionType> DEFEAT_COUNT = REGISTRY.register(ModRegistries.location("defeat_count"), () -> new LootItemConditionType(DefeatCountCondition.CODEC));

        public LootItemConditions(ModRegistries this$0) {
        }
    }

    public class CriteriaTriggers {
        public static final DeferredRegister<CriterionTrigger<?>> REGISTRY = DeferredRegister.create((String)"rctmod", (ResourceKey)Registries.TRIGGER_TYPE);
        public static final RegistrySupplier<DefeatCountTrigger> DEFEAT_COUNT = REGISTRY.register(ModRegistries.location("defeat_count"), DefeatCountTrigger::new);

        public CriteriaTriggers(ModRegistries this$0) {
        }
    }

    public class CreativeTabs {
        public static final DeferredRegister<CreativeModeTab> REGISTRY = DeferredRegister.create((String)"rctmod", (ResourceKey)Registries.CREATIVE_MODE_TAB);
        public static final RegistrySupplier<CreativeModeTab> CREATIVE_TAB = REGISTRY.register(ModRegistries.location("creative_tab"), () -> CreativeTabRegistry.create(builder -> builder.icon(() -> ((TrainerCard)((Object)((Object)((Object)((Object)Items.TRAINER_CARD.get()))))).getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.rctmod")).displayItems((context, entries) -> {
            entries.accept(((TrainerCard)((Object)((Object)((Object)((Object)Items.TRAINER_CARD.get()))))).getDefaultInstance());
            entries.accept(((BlockItem)Items.TRAINER_SPAWNER.get()).getDefaultInstance());
            entries.accept(((BlockItem)Items.TRAINER_REPEL_ROD.get()).getDefaultInstance());
        }).build()));

        public CreativeTabs(ModRegistries this$0) {
        }
    }
}

