/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data;

import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.advancements.criteria.DefeatCountTrigger;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemory;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TrainerBattle {
    private List<Player> initiatorSidePlayers;
    private List<TrainerMob> initiatorSideMobs;
    private List<Player> trainerSidePlayers;
    private List<TrainerMob> trainerSideMobs;

    public TrainerBattle(Player initiator, TrainerMob opponent) {
        this(new Player[]{initiator}, new TrainerMob[0], new Player[0], new TrainerMob[]{opponent});
    }

    public TrainerBattle(Player[] initiatorSidePlayers, TrainerMob[] initiatorSideMobs, Player[] trainerSidePlayers, TrainerMob[] trainerSideMobs) {
        if (initiatorSidePlayers.length == 0) {
            throw new UnsupportedOperationException("battle must have atleast 1 initiator player");
        }
        if (trainerSidePlayers.length == 0 && trainerSideMobs.length == 0) {
            throw new UnsupportedOperationException("battle must have atleast 1 trainer mob or player opponent");
        }
        this.initiatorSidePlayers = List.of(initiatorSidePlayers);
        this.initiatorSideMobs = List.of(initiatorSideMobs);
        this.trainerSidePlayers = List.of(trainerSidePlayers);
        this.trainerSideMobs = List.of(trainerSideMobs);
    }

    public Player getInitiator() {
        return this.initiatorSidePlayers.get(0);
    }

    public List<Player> getInitiatorSidePlayers() {
        return Collections.unmodifiableList(this.initiatorSidePlayers);
    }

    public List<TrainerMob> getInitiatorSideMobs() {
        return Collections.unmodifiableList(this.initiatorSideMobs);
    }

    public List<Player> getTrainerSidePlayers() {
        return Collections.unmodifiableList(this.trainerSidePlayers);
    }

    public List<TrainerMob> getTrainerSideMobs() {
        return Collections.unmodifiableList(this.trainerSideMobs);
    }

    public void distributeRewards(boolean initiatorWins) {
        List<Player> winnerPlayers = initiatorWins ? this.initiatorSidePlayers : this.trainerSidePlayers;
        List<TrainerMob> looserMobs = initiatorWins ? this.trainerSideMobs : this.initiatorSideMobs;
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        for (Player player : winnerPlayers) {
            for (TrainerMob mob : looserMobs) {
                TrainerPlayerData tpd = tm.getData(player);
                TrainerBattleMemory btm = tm.getBattleMemory(mob);
                tpd.addProgressDefeat(mob.getTrainerId());
                btm.addDefeatedBy(mob.getTrainerId(), player);
                ((DefeatCountTrigger)((Object)ModRegistries.CriteriaTriggers.DEFEAT_COUNT.get())).trigger((ServerPlayer)player, mob);
            }
        }
        for (TrainerMob mob : looserMobs) {
            mob.finishBattle(this, true);
        }
        for (TrainerMob mob : initiatorWins ? this.initiatorSideMobs : this.trainerSideMobs) {
            mob.finishBattle(this, false);
        }
    }
}

