/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.save;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

class TrainerBattleMemoryLegacy
extends SavedData {
    public static final int VERSION = 0;
    Map<UUID, Integer> defeatedBy = new HashMap<UUID, Integer>();

    TrainerBattleMemoryLegacy() {
    }

    public static TrainerBattleMemoryLegacy of(CompoundTag tag, HolderLookup.Provider provider) {
        TrainerBattleMemoryLegacy tbm = new TrainerBattleMemoryLegacy();
        tag.getAllKeys().forEach(key -> tbm.defeatedBy.put(UUID.fromString(key), tag.getInt(key)));
        return tbm;
    }

    public static String filePath(String trainerId) {
        return String.format("%s.trainers.%s.mem", "rctmod", trainerId);
    }

    public void addDefeatedBy(String trainerId, Player player) {
        Integer count = this.defeatedBy.get(player.getUUID());
        if (count == null) {
            count = 0;
        }
        if (count < Integer.MAX_VALUE) {
            RCTMod rct = RCTMod.getInstance();
            if (rct.getSeriesManager().getGraph(rct.getTrainerManager().getData(player).getCurrentSeries()).contains(trainerId)) {
                PlayerState.get(player).addDefeat(trainerId);
            }
            this.defeatedBy.put(player.getUUID(), count + 1);
            this.setDirty();
        }
    }

    public void setDefeatedaBy(String trainerId, Player player, int count) {
        Integer prevCount = this.defeatedBy.put(player.getUUID(), count);
        if (prevCount == null || prevCount != count) {
            RCTMod rct = RCTMod.getInstance();
            if (rct.getSeriesManager().getGraph(rct.getTrainerManager().getData(player).getCurrentSeries()).contains(trainerId)) {
                PlayerState.get(player).setDefeats(trainerId, count);
            }
            this.setDirty();
        }
    }

    public int getDefeatByCount(Player player) {
        Integer count = this.defeatedBy.get(player.getUUID());
        return count == null ? 0 : count;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        this.defeatedBy.forEach((uuid, count) -> compoundTag.putInt(uuid.toString(), count.intValue()));
        return compoundTag;
    }
}

