/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.utils;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public final class ChatUtils {
    private static Map<String, Text[]> defaultDialog = new HashMap<String, Text[]>();

    public static void initDefault(Map<String, Text[]> defaultDialog) {
        ChatUtils.defaultDialog = defaultDialog == null ? Map.of() : defaultDialog;
    }

    public static void reply(TrainerMob source, Player target, String ... contexts) {
        TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(source);
        ChatUtils.reply((LivingEntity)source, target, (String context) -> tmd.getDialog().get(context), contexts);
    }

    public static void reply(LivingEntity source, Player target, String ... contexts) {
        ChatUtils.reply(source, target, (String context) -> defaultDialog.get(context), contexts);
    }

    private static void reply(LivingEntity source, Player target, Function<String, Text[]> messagesFunc, String ... contexts) {
        for (String context : contexts) {
            Text[] messages = messagesFunc.apply(context);
            if (messages == null) continue;
            if (messages.length > 0) {
                PlayerChatMessage message = PlayerChatMessage.system((String)"").withUnsignedContent((Component)messages[(target.getRandom().nextInt() & Integer.MAX_VALUE) % messages.length].getComponent(new Object[0]));
                target.createCommandSourceStack().sendChatMessage(OutgoingChatMessage.create((PlayerChatMessage)message), false, ChatType.bind((ResourceKey)ChatType.CHAT, (Entity)source));
                return;
            }
            ModCommon.LOG.error(String.format("Empty dialog context '%s'", context));
            return;
        }
        ModCommon.LOG.error(String.format("Invalid dialog contexts '%s'", String.valueOf(contexts)));
    }

    public static void replyRaw(LivingEntity source, Player target, Text text, Object ... args) {
        PlayerChatMessage message = PlayerChatMessage.system((String)"").withUnsignedContent((Component)text.getComponent(args));
        target.createCommandSourceStack().sendChatMessage(OutgoingChatMessage.create((PlayerChatMessage)message), false, ChatType.bind((ResourceKey)ChatType.CHAT, (Entity)source));
    }

    public static void sendMessage(Player target, Text text, Object ... args) {
        target.createCommandSourceStack().sendSystemMessage((Component)text.getComponent(args));
    }

    public static void broadcastMessage(MinecraftServer server, Text text, int opLevel, Object ... args) {
        server.getPlayerList().getPlayers().stream().filter(pl -> pl.hasPermissions(opLevel)).forEach(pl -> ChatUtils.sendMessage((Player)pl, text, args));
    }

    public static void sendError(Player target, Text text, Object ... args) {
        target.createCommandSourceStack().sendSystemMessage((Component)text.getComponent(args).withStyle(ChatFormatting.RED));
    }

    public static void broadcastError(MinecraftServer server, Text text, int opLevel, Object ... args) {
        server.getPlayerList().getPlayers().stream().filter(pl -> pl.hasPermissions(opLevel)).forEach(pl -> ChatUtils.sendError((Player)pl, text, args));
    }

    public static void sendTitle(Player target, Text title, Text subtitle, Object ... args) {
        try {
            CommandSourceStack cs = target.createCommandSourceStack().withPermission(2).withSuppressedOutput();
            if (subtitle != null && !subtitle.isEmpty()) {
                cs.dispatcher().execute(String.format("title @s subtitle %s", Component.Serializer.toJson((Component)subtitle.getComponent(args).withStyle(ChatFormatting.ITALIC), (HolderLookup.Provider)target.registryAccess())), (Object)cs);
            }
            if (title == null) {
                title = Text.empty();
            }
            cs.dispatcher().execute(String.format("title @s title %s", Component.Serializer.toJson((Component)title.getComponent(args), (HolderLookup.Provider)target.registryAccess())), (Object)cs);
        }
        catch (CommandSyntaxException e) {
            ModCommon.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void sendActionbar(Player target, Text message, Object ... args) {
        try {
            CommandSourceStack cs = target.createCommandSourceStack().withPermission(2).withSuppressedOutput();
            cs.dispatcher().execute(String.format("title @s actionbar %s", Component.Serializer.toJson((Component)message.getComponent(args), (HolderLookup.Provider)target.registryAccess())), (Object)cs);
        }
        catch (CommandSyntaxException e) {
            ModCommon.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private ChatUtils() {
    }
}

