/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerInfoWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerListWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.controls.CycleButton;
import com.gitlab.srcmc.rctmod.client.screens.widgets.text.AutoScaledStringWidget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.include.com.google.common.base.Strings;

public class PlayerInfoWidget
extends AbstractWidget {
    public static final ResourceLocation TRAINER_CARD_IMAGE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)"textures/gui/trainer_card.png");
    public static final int TRAINER_CARD_IMAGE_X = 0;
    public static final int TRAINER_CARD_IMAGE_Y = 0;
    public static final int TRAINER_CARD_IMAGE_W = 224;
    public static final int TRAINER_CARD_IMAGE_H = 128;
    public static final int SKIN_X = 13;
    public static final int SKIN_Y = 32;
    public static final int SKIN_SIZE = 72;
    public static final int DISPLAY_NAME_X = 16;
    public static final int DISPLAY_NAME_Y = 8;
    public static final int DISPLAY_NAME_W = 66;
    public static final int DISPLAY_NAME_H = 16;
    public static final int LEVEL_CAP_X = 8;
    public static final int LEVEL_CAP_Y = 104;
    public static final int LEVEL_CAP_W = 82;
    public static final int LEVEL_CAP_H = 16;
    public static final int LEVEL_CAP_PADDING = 4;
    public static final int TOTAL_DEFEATS_X = 96;
    public static final int TOTAL_DEFEATS_Y = 104;
    public static final int TOTAL_DEFEATS_W = 88;
    public static final int TOTAL_DEFEATS_H = 16;
    public static final int TOTAL_DEFEATS_PADDING = 4;
    public static final int TRAINER_LIST_X = 96;
    public static final int TRAINER_LIST_Y = 32;
    public static final int TRAINER_LIST_W = 112;
    public static final int TRAINER_LIST_H = 72;
    public static final int TYPE_BUTTON_X = 96;
    public static final int TYPE_BUTTON_Y = 8;
    public static final int TYPE_BUTTON_W = 100;
    public static final int TYPE_BUTTON_H = 16;
    public static final int CHECKBOX_X = 196;
    public static final int CHECKBOX_Y = 8;
    public static final int CHECKBOX_W = 20;
    public static final int CHECKBOX_H = 16;
    public static final List<String> CHECKBOX_VALUES = List.of(" ", "\u2714");
    public static final int NEXT_PAGE_BUTTON_X = 200;
    public static final int NEXT_PAGE_BUTTON_Y = 104;
    public static final int NEXT_PAGE_BUTTON_SIZE = 16;
    public static final int LOADING_W = 112;
    public static final int LOADING_H = 8;
    public static final int LOADING_X = 96;
    public static final int LOADING_Y = 64;
    private StringWidget displayName;
    private StringWidget levelCapLabel;
    private StringWidget levelCapValue;
    private StringWidget totalDefeatsLabel;
    private StringWidget totalDefeatsValue;
    private StringWidget loadingLabel;
    private TrainerListWidget trainerList;
    private TrainerInfoWidget trainerInfo;
    private CycleButton<TrainerType> trainerTypeButton;
    private Button nextPageButton;
    private Button prevPageButton;
    private CycleButton<String> showUndefeated;
    private AbstractWidget[] renderableWidgets;
    private AbstractWidget[] renderableOnlies;
    private Boolean trainerListShowUndefeated;
    private Component trainerListType;
    private ResourceLocation skinLocation;
    private Font font;
    private List<TrainerType> trainerTypes;
    private String sid;
    private Display currentDisplay;
    private int loadingTick;

    public PlayerInfoWidget(int x, int y, int w, int h, Font font) {
        super(x, y, w, h, (Component)Component.empty());
        this.active = false;
        this.font = font;
        this.displayName = new AutoScaledStringWidget(x + 16, y + 8, 66, 16, (Component)Component.empty(), this.font).alignCenter().fitting(true);
        this.levelCapLabel = new StringWidget(x + 8 + 4, y + 104 + 2, 82, 16, (Component)Component.translatable((String)"gui.rctmod.trainer_card.level_cap").withStyle(ChatFormatting.WHITE), this.font).alignLeft();
        this.levelCapValue = new StringWidget(x + 8, y + 104 + 2, 78, 16, (Component)Component.empty(), this.font).alignRight();
        this.totalDefeatsLabel = new StringWidget(x + 96 + 4, y + 104 + 2, 88, 16, (Component)Component.translatable((String)"gui.rctmod.trainer_card.total").withStyle(ChatFormatting.WHITE), this.font).alignLeft();
        this.totalDefeatsValue = new StringWidget(x + 96, y + 104 + 2, 84, 16, (Component)Component.empty(), this.font).alignRight();
        this.loadingLabel = new AutoScaledStringWidget(x + 96, y + 64, 112, 8, (Component)Component.empty(), this.font).alignCenter().scaled(0.65f);
        this.trainerList = new TrainerListWidget(x + 96, y + 32, 112, 72, font, this.sortedTrainerIds());
        this.trainerInfo = new TrainerInfoWidget(x + 96, y + 32, 112, 72, font);
        this.trainerTypes = new ArrayList<TrainerType>();
        this.showUndefeated = CycleButton.create(t -> Component.literal((String)t), CHECKBOX_VALUES, 1, x + 196, y + 8, 20, 16, true);
        this.trainerTypeButton = CycleButton.create(t -> t.name().getComponent(new Object[0]), this.trainerTypes, 0, x + 96, y + 8, 100, 16, false);
        this.nextPageButton = Button.builder((Component)Component.literal((String)">"), this::onNextPage).pos(x + 200, y + 104).size(16, 16).build();
        this.prevPageButton = Button.builder((Component)Component.literal((String)"<"), this::onPrevPage).pos(x + 200 - 16, y + 104).size(16, 16).build();
        this.renderableWidgets = new AbstractWidget[]{this.trainerList, this.trainerInfo, this.trainerTypeButton, this.showUndefeated, this.prevPageButton, this.nextPageButton};
        this.renderableOnlies = new AbstractWidget[]{this.displayName, this.levelCapLabel, this.levelCapValue, this.totalDefeatsLabel, this.totalDefeatsValue, this.loadingLabel};
        this.trainerList.setOnTrainerClicked((trainerNr, trainerId, entryState) -> {
            this.trainerInfo.initTrainerInfo(trainerNr, trainerId, entryState);
            this.trainerInfo.setPage(0);
            this.setDisplay(Display.TRAINER_INFO);
        });
        this.trainerInfo.setOnBackClicked(i -> this.setDisplay(Display.TRAINER_LIST));
        this.setDisplay(Display.LOADING);
    }

    private void resetTrainerTypes() {
        this.trainerTypes.clear();
    }

    public AbstractWidget[] getRenderableWidgets() {
        return this.renderableWidgets;
    }

    public AbstractWidget[] getRenderableOnlies() {
        return this.renderableOnlies;
    }

    public void setDisplay(Display display) {
        switch (display.ordinal()) {
            case 0: {
                if (this.currentDisplay == Display.LOADING) {
                    this.resetTrainerTypes();
                    this.updateTrainerTypes(this.sid);
                    this.trainerList.setTrainerIds(this.sortedTrainerIds());
                }
                this.trainerInfo.active = false;
                this.trainerInfo.visible = false;
                this.trainerList.active = true;
                this.trainerList.visible = true;
                this.showUndefeated.active = true;
                this.trainerTypeButton.active = true;
                this.loadingLabel.setMessage((Component)Component.empty());
                if (this.trainerListShowUndefeated != null) {
                    if (this.trainerListShowUndefeated.booleanValue() != this.isShowUndefeatedSelected()) {
                        this.showUndefeated.onPress();
                    }
                    this.trainerListShowUndefeated = null;
                }
                if (this.trainerListType == null) break;
                this.trainerTypeButton.setMessage(this.trainerListType);
                this.trainerListType = null;
                break;
            }
            case 1: {
                if (this.trainerListShowUndefeated == null) {
                    this.trainerListShowUndefeated = this.isShowUndefeatedSelected();
                }
                if (this.trainerListType == null) {
                    this.trainerListType = this.trainerTypeButton.getMessage();
                }
                if (this.isShowUndefeatedSelected()) {
                    this.showUndefeated.onPress();
                }
                this.trainerInfo.active = true;
                this.trainerInfo.visible = true;
                this.trainerList.active = false;
                this.trainerList.visible = false;
                this.prevPageButton.active = false;
                this.nextPageButton.active = false;
                this.showUndefeated.active = false;
                this.trainerTypeButton.active = false;
                this.trainerTypeButton.setMessage(this.trainerInfo.getPageContent((int)this.trainerInfo.getPage()).title);
                this.loadingLabel.setMessage((Component)Component.empty());
                break;
            }
            case 2: {
                if (this.isShowUndefeatedSelected()) {
                    this.showUndefeated.onPress();
                }
                this.trainerInfo.active = false;
                this.trainerInfo.visible = false;
                this.trainerList.active = true;
                this.trainerList.visible = true;
                this.trainerListShowUndefeated = true;
                this.showUndefeated.active = false;
                this.trainerTypeButton.active = false;
                this.trainerList.setTrainerIds(List.of());
                this.trainerList.setPage(0);
                this.resetTrainerTypes();
            }
        }
        this.currentDisplay = display;
    }

    private void updateLoading() {
        this.loadingLabel.setMessage((Component)Component.literal((String)(Component.translatable((String)"gui.rctmod.trainer_card.loading").getString() + Strings.repeat((String)".", (int)(this.loadingTick / 15 % 6)))).withStyle(ChatFormatting.GREEN));
    }

    public void tick() {
        Minecraft mc = Minecraft.getInstance();
        PlayerState ps = PlayerState.get((Player)mc.player);
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        int levelCap = this.currentDisplay == Display.LOADING ? 0 : ps.getLevelCap();
        this.sid = ps.getCurrentSeries();
        this.skinLocation = mc.player.getSkin().texture();
        this.displayName.setMessage((Component)Component.literal((String)mc.player.getDisplayName().getString()).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.WHITE));
        this.levelCapValue.setMessage((Component)(levelCap <= 100 ? Component.literal((String)String.valueOf(levelCap)).withStyle(ChatFormatting.WHITE) : Component.literal((String)"000").withStyle(ChatFormatting.OBFUSCATED).withStyle(ChatFormatting.WHITE)));
        if (tm.isLoading() || ps.isLoading()) {
            if (this.currentDisplay != Display.LOADING) {
                this.setDisplay(Display.LOADING);
                this.loadingTick = 0;
            }
            this.updateLoading();
            ++this.loadingTick;
        } else if (this.currentDisplay == Display.LOADING) {
            this.setDisplay(Display.TRAINER_LIST);
        }
        if (this.trainerList.active) {
            long totalDefeats = this.currentDisplay == Display.LOADING ? 0L : this.getTotalDefeats();
            this.totalDefeatsValue.setMessage((Component)(totalDefeats < 1000000L ? Component.literal((String)String.valueOf(totalDefeats)).withStyle(ChatFormatting.WHITE) : Component.literal((String)"1000000").withStyle(ChatFormatting.OBFUSCATED).withStyle(ChatFormatting.WHITE)));
            this.nextPageButton.active = this.trainerList.getPage() < this.trainerList.getMaxPage();
            this.prevPageButton.active = this.trainerList.getPage() > 0;
            int trainerTypeIndex = this.trainerTypeButton.getIndex();
            boolean showUndefeated = this.isShowUndefeatedSelected();
            boolean showAllTypes = trainerTypeIndex == 0;
            this.trainerList.setTrainerType(showAllTypes ? TrainerType.DEFAULT : this.trainerTypeButton.getValue());
            this.trainerList.setShowAllTypes(showAllTypes);
            this.trainerList.setShowUndefeated(showUndefeated);
            this.trainerList.tick();
        } else if (this.trainerInfo.active) {
            int defeats = this.getDefeats(this.trainerInfo.getTrainerId());
            this.totalDefeatsValue.setMessage((Component)(defeats < 1000000 ? Component.literal((String)String.valueOf(defeats)).withStyle(ChatFormatting.WHITE) : Component.literal((String)"1000000").withStyle(ChatFormatting.OBFUSCATED).withStyle(ChatFormatting.WHITE)));
            this.nextPageButton.active = this.trainerInfo.getPage() < this.trainerInfo.getMaxPage();
            this.prevPageButton.active = this.trainerInfo.getPage() > 0;
            this.trainerInfo.tick();
        }
    }

    private void updateTrainerTypes(String sid) {
        sid = sid == null ? "" : sid;
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        SeriesManager.SeriesGraph sg = sm.getGraph(sid);
        Iterator it = sg.stream().iterator();
        LinkedList<TrainerType> open = new LinkedList<TrainerType>(TrainerType.values());
        this.trainerTypes.add(new TrainerType(sg.getMetaData().title()));
        while (it.hasNext() && !open.isEmpty()) {
            TrainerType tt = tm.getData(((SeriesManager.TrainerNode)it.next()).id()).getType();
            Iterator it2 = open.iterator();
            while (it2.hasNext()) {
                TrainerType t = (TrainerType)it2.next();
                if (!tt.equals(t)) continue;
                this.trainerTypes.add(t);
                it2.remove();
            }
        }
        this.trainerTypeButton.setValue(0);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.blit(TRAINER_CARD_IMAGE_LOCATION, this.getX(), this.getY(), 0, 0, 224, 128);
        if (this.skinLocation != null) {
            PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (ResourceLocation)this.skinLocation, (int)(this.getX() + 13), (int)(this.getY() + 32), (int)72);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private boolean isShowUndefeatedSelected() {
        return this.showUndefeated.getValue().equals(CHECKBOX_VALUES.get(1));
    }

    private void onNextPage(Button button) {
        if (this.trainerList.active) {
            this.trainerList.setPage(this.trainerList.getPage() + 1);
        }
        if (this.trainerInfo.active) {
            this.trainerInfo.setPage(this.trainerInfo.getPage() + 1);
            this.trainerTypeButton.setMessage(this.trainerInfo.getPageContent((int)this.trainerInfo.getPage()).title);
        }
    }

    private void onPrevPage(Button button) {
        if (this.trainerList.active) {
            this.trainerList.setPage(this.trainerList.getPage() - 1);
        }
        if (this.trainerInfo.active) {
            this.trainerInfo.setPage(this.trainerInfo.getPage() - 1);
            this.trainerTypeButton.setMessage(this.trainerInfo.getPageContent((int)this.trainerInfo.getPage()).title);
        }
    }

    private long getTotalDefeats() {
        if (!this.isShowUndefeatedSelected()) {
            return this.trainerList.getShowAllTypes() ? this.getDistinctDefeats() : this.getDistinctDefeats(this.trainerList.getTrainerType());
        }
        if (!this.trainerList.getShowAllTypes()) {
            return this.getTotalDefeats(this.trainerList.getTrainerType());
        }
        Minecraft mc = Minecraft.getInstance();
        PlayerState playerState = PlayerState.get((Player)mc.player);
        return playerState.getTrainerDefeatCount();
    }

    private long getTotalDefeats(TrainerType type) {
        Minecraft mc = Minecraft.getInstance();
        PlayerState playerState = PlayerState.get((Player)mc.player);
        return playerState.getTypeDefeatCount(type);
    }

    private long getDistinctDefeats() {
        Minecraft mc = Minecraft.getInstance();
        PlayerState playerState = PlayerState.get((Player)mc.player);
        int count = 0;
        for (TrainerType t : TrainerType.values()) {
            count = (int)((long)count + playerState.getTypeDefeatCount(t, true));
        }
        return count;
    }

    private long getDistinctDefeats(TrainerType type) {
        Minecraft mc = Minecraft.getInstance();
        PlayerState playerState = PlayerState.get((Player)mc.player);
        return playerState.getTypeDefeatCount(type, true);
    }

    private int getDefeats(String trainerId) {
        Minecraft mc = Minecraft.getInstance();
        PlayerState playerState = PlayerState.get((Player)mc.player);
        return playerState.getTrainerDefeatCount(trainerId);
    }

    private List<String> sortedTrainerIds() {
        Minecraft mc = Minecraft.getInstance();
        PlayerState playerState = PlayerState.get((Player)mc.player);
        TrainerManager tdm = RCTMod.getInstance().getTrainerManager();
        return tdm.getAllData(playerState.getCurrentSeries()).map(entry -> (String)entry.getKey()).sorted((k1, k2) -> {
            TrainerMobData t1 = tdm.getData((String)k1);
            TrainerMobData t2 = tdm.getData((String)k2);
            int c = t1.getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0) - t2.getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0);
            if (c == 0 && (c = t1.getTrainerTeam().getName().compareTo(t2.getTrainerTeam().getName())) == 0) {
                c = k1.compareTo((String)k2);
            }
            return c;
        }).toList();
    }

    public static enum Display {
        TRAINER_LIST,
        TRAINER_INFO,
        LOADING;

    }
}

