/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.mixins;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import com.gitlab.srcmc.rctmod.world.entities.TrainerAssociation;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MerchantResultSlot.class})
public class MerchantResultSlotMixin {
    @Shadow
    @Final
    private Merchant merchant;
    @Shadow
    @Final
    private MerchantContainer slots;

    @Inject(method={"onTake(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="RETURN")}, remap=true)
    public void inject_onTake(Player player, ItemStack itemStack, CallbackInfo ci) {
        Merchant merchant = this.merchant;
        if (merchant instanceof TrainerAssociation) {
            TrainerAssociation ta = (TrainerAssociation)merchant;
            MerchantResultSlotMixin.offerSeriesSwitch(ta, player, itemStack);
        }
    }

    @Inject(method={"onQuickCraft(Lnet/minecraft/world/item/ItemStack;I)V"}, at={@At(value="RETURN")}, remap=true)
    protected void inject_onQuickCraft(ItemStack itemStack, int i, CallbackInfo ci) {
        Merchant merchant = this.merchant;
        if (merchant instanceof TrainerAssociation) {
            TrainerAssociation ta = (TrainerAssociation)merchant;
            MerchantResultSlotMixin.offerSeriesSwitch(ta, ta.getTradingPlayer(), itemStack);
        }
    }

    private static void offerSeriesSwitch(TrainerAssociation ta, Player player, ItemStack itemStack) {
        Map.Entry<String, ItemStack> offer;
        if (!itemStack.isEmpty() && (offer = ta.takeOffer()) != null) {
            boolean seriesContinued;
            if (!MerchantResultSlotMixin.replaceDummy(player, itemStack, offer.getValue())) {
                itemStack.remove(DataComponents.CUSTOM_NAME);
                itemStack.remove(DataComponents.LORE);
                itemStack.applyComponents(offer.getValue().getComponents());
            }
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
            boolean seriesPaused = "freeroam".equals(offer.getKey());
            boolean bl = seriesContinued = "freeroam".equals(tpd.getCurrentSeries()) && offer.getKey().equals(tpd.getPreviousSeries());
            ChatUtils.sendTitle(player, Text.translatable((String)(seriesPaused ? "gui.rctmod.title.series_paused" : (seriesContinued ? "gui.rctmod.title.series_continued" : "gui.rctmod.title.series_started"))), RCTMod.getInstance().getSeriesManager().getGraph(seriesPaused ? tpd.getCurrentSeries() : offer.getKey()).getMetaData().title(), new Object[0]);
            tpd.setCurrentSeries(offer.getKey(), seriesPaused || seriesContinued);
            ta.updateOffersFor(player);
        }
    }

    private static boolean replaceDummy(Player player, ItemStack dummy, ItemStack replacement) {
        Inventory inv = player.getInventory();
        int i = inv.findSlotMatchingItem(dummy);
        if (i >= 0) {
            inv.setItem(i, replacement);
            return true;
        }
        return false;
    }
}

