/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.blocks.entities;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.world.blocks.TrainerSpawnerBlock;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TrainerSpawnerBlockEntity
extends BlockEntity {
    private static final int OWNER_UPDATE_INTERVAL_TICKS = 40;
    private static final int SPAWN_INTERVAL_TICKS = 80;
    private static final int SCAN_INTERVAL_TICKS = 200;
    private static final double HOME_SWITCH_CHANCE = 0.1;
    public final RenderState renderState = new RenderState(this);
    private Set<String> trainerIds = new HashSet<String>();
    private TrainerMob ownerTrainer;
    private UUID ownerUUID;
    private double minPlayerDistance;
    private double maxPlayerDistance;
    private Queue<Consumer<TrainerManager>> updateQueue = new LinkedList<Consumer<TrainerManager>>();
    private Set<Item> renderItems = new HashSet<Item>();
    private Timer ownerUpdateTimer = new Timer(this);
    private Timer spawnTimer = new Timer(this);
    private Timer scanTimer = new Timer(this);
    private AABB aabb;

    public TrainerSpawnerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistries.BlockEntityTypes.TRAINER_SPAWNER.get(), blockPos, blockState);
        this.setPlayerDistanceThreshold(2.0, (double)RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers() * 0.6666666666666666);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.ownerUUID != null) {
            tag.putUUID("OwnerUUID", this.ownerUUID);
        }
        ListTag tids = new ListTag();
        tids.addAll(this.trainerIds.stream().map(StringTag::valueOf).toList());
        tag.put("TrainerIds", (Tag)tids);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.trainerIds.clear();
        UUID uUID = this.ownerUUID = tag.contains("OwnerUUID") ? tag.getUUID("OwnerUUID") : null;
        if (tag.contains("renderItemKey")) {
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("renderItemKey")));
            this.addTrainerIdsFromItem(item.getDefaultInstance());
        }
        if (tag.contains("TrainerIds")) {
            this.trainerIds.addAll(tag.getCompound("TrainerIds").getAllKeys());
            this.trainerIds.addAll(tag.getList("TrainerIds", 8).stream().map(Tag::getAsString).toList());
        }
        this.updateOwner();
        this.updateRenderItems();
    }

    private void update() {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        if (!tm.isLoading()) {
            while (!this.updateQueue.isEmpty()) {
                this.updateQueue.poll().accept(tm);
            }
        }
    }

    private void updateRenderItems() {
        this.updateQueue.add(tm -> {
            this.renderItems.clear();
            this.trainerIds.forEach(tid -> {
                String renderItemKey = tm.getData((String)tid).getSignatureItem();
                if (renderItemKey != null && !renderItemKey.isBlank()) {
                    ResourceLocation rl = ResourceLocation.parse((String)renderItemKey);
                    if (!BuiltInRegistries.ITEM.containsKey(rl)) {
                        ModCommon.LOG.error(String.format("Invalid Trainer Spawner item for '%s': %s", tid, rl.toString()));
                    } else {
                        Item item = (Item)BuiltInRegistries.ITEM.get(rl);
                        this.renderItems.add(item);
                    }
                }
            });
        });
    }

    private void syncToClients() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public void setOwner(TrainerMob ownerTrainer) {
        if (ownerTrainer != this.ownerTrainer) {
            if (this.ownerTrainer != null) {
                this.ownerTrainer.setHomeSpawner(null);
            }
            this.ownerTrainer = ownerTrainer;
            if (this.ownerTrainer != null) {
                TrainerSpawnerBlockEntity oldSpawner = this.ownerTrainer.getHomeSpawner();
                if (oldSpawner != this && oldSpawner != null) {
                    oldSpawner.setOwner(null);
                }
                this.ownerTrainer.setHomeSpawner(this);
                this.setOwnerUUID(this.ownerTrainer.getUUID());
            }
        }
        if (this.ownerTrainer == null) {
            this.setOwnerUUID(null);
        }
    }

    protected void setOwnerUUID(UUID ownerUUID) {
        if (!Objects.equals(this.ownerUUID, ownerUUID)) {
            this.ownerUUID = ownerUUID;
            this.setChanged();
            this.syncToClients();
        }
    }

    public TrainerMob getOwner() {
        return this.ownerTrainer;
    }

    protected void updateOwner() {
        if (this.ownerUUID != null) {
            if (this.ownerTrainer == null) {
                RCTMod.getInstance().getTrainerSpawner().getSpawns().stream().filter(tm -> tm.getUUID().equals(this.ownerUUID)).findAny().ifPresent(tm -> {
                    this.ownerTrainer = tm;
                });
            }
            if (this.ownerTrainer == null || !this.ownerTrainer.isAlive()) {
                this.setOwner(null);
            } else {
                this.setOwner(this.ownerTrainer);
            }
        }
    }

    private void addTrainerIdsFromItem(ItemStack item) {
        this.updateQueue.add(tm -> this.addTrainerIdsFromItem((TrainerManager)tm, item));
    }

    public boolean addTrainerIdsFromItem(TrainerManager tm, ItemStack item) {
        boolean[] added = new boolean[]{false};
        if (!tm.isLoading()) {
            String itemId = item.getItem().arch$registryName().toString();
            tm.getAllData(new String[0]).filter(e -> itemId.equals(((TrainerMobData)e.getValue()).getSignatureItem())).forEach(e -> {
                if (this.trainerIds.add((String)e.getKey())) {
                    added[0] = true;
                }
            });
            if (added[0]) {
                this.setChanged();
                this.syncToClients();
            }
        }
        return added[0];
    }

    public Set<String> getTrainerIds() {
        return this.trainerIds;
    }

    public Set<Item> getRenderItems() {
        return this.renderItems;
    }

    public double getMinPlayerDistance() {
        return this.minPlayerDistance;
    }

    public double getMaxPlayerDistance() {
        return this.maxPlayerDistance;
    }

    protected void setPlayerDistanceThreshold(double min, double max) {
        this.minPlayerDistance = Math.min(min, max);
        this.maxPlayerDistance = max;
        this.aabb = new AABB(this.getBlockPos()).inflate(max);
    }

    private void attemptSpawn(Level level, BlockPos blockPos, BlockState blockState) {
        Vec3 pos = blockPos.getCenter();
        Player nearest = level.getNearestPlayer(TargetingConditions.forNonCombat(), null, pos.x, pos.y, pos.z);
        if (nearest == null || nearest.distanceToSqr(pos) < Math.pow(this.minPlayerDistance, 2.0) / 2.0) {
            return;
        }
        boolean guaruantee = TrainerSpawnerBlock.isPowered(blockState);
        TrainerSpawner spawner = RCTMod.getInstance().getTrainerSpawner();
        ArrayList<String> trainerIds = new ArrayList<String>(this.getTrainerIds());
        Collections.shuffle(trainerIds);
        for (Player player : level.getNearbyPlayers(TargetingConditions.forNonCombat(), null, this.aabb)) {
            for (String trainerId : trainerIds) {
                TrainerMob m = spawner.attemptSpawnFor(player, trainerId, this.getBlockPos().above(), true, true, guaruantee, 1.0, 1.0);
                if (m == null) continue;
                this.setOwner(m);
                return;
            }
        }
    }

    private void scanForTrainerNearby(Level level) {
        Set<String> trainerIds = this.getTrainerIds();
        level.getNearbyEntities(TrainerMob.class, TargetingConditions.forNonCombat(), null, this.aabb).stream().filter(t -> trainerIds.contains(t.getTrainerId())).filter(t -> t.getHomePos() == null || t.getRandom().nextDouble() < 0.1).findAny().ifPresent(t -> this.setOwner((TrainerMob)((Object)t)));
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TrainerSpawnerBlockEntity be) {
        be.update();
        if (be.ownerUpdateTimer.passed(level.getGameTime()) >= 40L) {
            be.updateOwner();
            be.ownerUpdateTimer.reset(level.getGameTime());
        }
        if (be.getTrainerIds().size() > 0) {
            if (be.ownerUUID == null && be.spawnTimer.passed(level.getGameTime()) >= 80L) {
                be.attemptSpawn(level, blockPos, blockState);
                be.spawnTimer.reset(level.getGameTime());
            }
            if (be.ownerUUID == null && be.scanTimer.passed(level.getGameTime()) >= 200L) {
                be.scanForTrainerNearby(level);
                be.scanTimer.reset(level.getGameTime());
            }
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TrainerSpawnerBlockEntity be) {
        be.update();
    }

    public class RenderState {
        public double p;
        public double targetP;

        public RenderState(TrainerSpawnerBlockEntity this$0) {
        }
    }

    class Timer {
        private long prev;
        private long total;

        Timer(TrainerSpawnerBlockEntity this$0) {
        }

        public void reset(long now) {
            this.prev = now;
            this.total = 0L;
        }

        public long passed(long now) {
            this.total += now - this.prev;
            this.prev = now;
            return this.total;
        }
    }
}

