/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;

public class MoveCloseToTargetGoal
extends MoveTowardsTargetGoal {
    private static final int DEFAULT_SOCIAL_DISTANCING = 36;
    private static final int PAUSE_MIN_TICKS = 0;
    private static final int PAUSE_MAX_TICKS = 200;
    private TrainerMob mob;
    private double minDistanceSquared;
    private double speedModifier;
    private float probability;
    private int pauseTicks;

    public MoveCloseToTargetGoal(TrainerMob pathfinderMob, double d, float f) {
        this(pathfinderMob, d, 0.5f, f, 36.0f);
    }

    public MoveCloseToTargetGoal(TrainerMob pathfinderMob, double d, float p, float f) {
        this(pathfinderMob, d, p, f, 36.0f);
    }

    public MoveCloseToTargetGoal(TrainerMob pathfinderMob, double d, float p, float f, float g) {
        super((PathfinderMob)pathfinderMob, d, f);
        this.mob = pathfinderMob;
        this.probability = p;
        this.minDistanceSquared = g * g;
        this.speedModifier = d;
    }

    public boolean canUse() {
        boolean can;
        boolean bl = can = this.mob.getRandom().nextFloat() < this.probability && this.mob.isRequiredBy(this.mob.getTarget()) && super.canUse() && !this.isNearbyTarget();
        if (can) {
            this.pauseTicks = this.mob.getRandom().nextInt(0, 200);
            this.probability = (float)((double)this.probability * 0.75);
        }
        return can;
    }

    public boolean canContinueToUse() {
        if (!this.mob.isInWater() && !this.mob.isInLava() && this.mob.getRandom().nextInt(600) == 0) {
            return false;
        }
        return super.canContinueToUse() && !this.isNearbyTarget();
    }

    private boolean isNearbyTarget() {
        LivingEntity target = this.mob.getTarget();
        return target != null && target.distanceToSqr((Entity)this.mob) < this.minDistanceSquared;
    }

    public void tick() {
        if (this.pauseTicks < 0) {
            this.mob.getNavigation().setSpeedModifier(this.mob.isInWater() || this.mob.isInLava() ? 1.0 : this.speedModifier);
            super.tick();
        } else {
            this.mob.getNavigation().setSpeedModifier(0.0);
            --this.pauseTicks;
        }
    }
}

