/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.sliceanddice.block.slicer;

import com.possible_triangle.sliceanddice.Content;
import com.possible_triangle.sliceanddice.block.slicer.SlicerBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/possible_triangle/sliceanddice/block/slicer/SlicerItemHandler;", "Lnet/neoforged/neoforge/items/IItemHandlerModifiable;", "tile", "Lcom/possible_triangle/sliceanddice/block/slicer/SlicerBlockEntity;", "<init>", "(Lcom/possible_triangle/sliceanddice/block/slicer/SlicerBlockEntity;)V", "getSlots", "", "getStackInSlot", "Lnet/minecraft/world/item/ItemStack;", "slot", "insertItem", "stack", "simulate", "", "extractItem", "amount", "getSlotLimit", "isItemValid", "setStackInSlot", "", "sliceanddice-forge-4.1.2"})
public final class SlicerItemHandler
implements IItemHandlerModifiable {
    @NotNull
    private final SlicerBlockEntity tile;

    public SlicerItemHandler(@NotNull SlicerBlockEntity tile) {
        Intrinsics.checkNotNullParameter((Object)((Object)tile), (String)"tile");
        this.tile = tile;
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStack itemStack;
        if (slot == 0) {
            itemStack = this.tile.getHeldItem();
        } else {
            ItemStack itemStack2 = ItemStack.EMPTY;
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        }
        return itemStack;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (slot == 0 && this.tile.getHeldItem().isEmpty()) {
            if (!simulate) {
                this.tile.setHeldItem(stack);
            }
            ItemStack itemStack2 = ItemStack.EMPTY;
            Intrinsics.checkNotNull((Object)itemStack2);
            itemStack = itemStack2;
        } else {
            itemStack = stack;
        }
        return itemStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack itemStack;
        if (slot == 0) {
            ItemStack copy = this.tile.getHeldItem().copy();
            if (!simulate) {
                this.tile.setHeldItem(ItemStack.EMPTY);
            }
            ItemStack itemStack2 = copy;
            Intrinsics.checkNotNull((Object)itemStack2);
            itemStack = itemStack2;
        } else {
            ItemStack itemStack3 = ItemStack.EMPTY;
            Intrinsics.checkNotNull((Object)itemStack3);
            itemStack = itemStack3;
        }
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return !stack.isEmpty() && stack.is(Content.INSTANCE.getALLOWED_TOOLS());
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!this.isItemValid(slot, stack)) {
            return;
        }
        if (slot == 0) {
            this.tile.setHeldItem(stack);
        }
    }
}

