/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.sliceanddice.block.sprinkler;

import com.possible_triangle.sliceanddice.block.sprinkler.RegisteredBehaviour;
import com.possible_triangle.sliceanddice.config.Configs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000 \r2\u00020\u0001:\u0002\f\rJ(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\u000e"}, d2={"Lcom/possible_triangle/sliceanddice/block/sprinkler/SprinkleBehaviour;", "", "act", "", "range", "Lcom/possible_triangle/sliceanddice/block/sprinkler/SprinkleBehaviour$Range;", "world", "Lnet/minecraft/server/level/ServerLevel;", "fluidStack", "Lnet/neoforged/neoforge/fluids/FluidStack;", "random", "Lnet/minecraft/util/RandomSource;", "Range", "Companion", "sliceanddice-forge-4.1.2"})
public interface SprinkleBehaviour {
    @NotNull
    public static final Companion Companion = com.possible_triangle.sliceanddice.block.sprinkler.SprinkleBehaviour$Companion.$$INSTANCE;

    public void act(@NotNull Range var1, @NotNull ServerLevel var2, @NotNull FluidStack var3, @NotNull RandomSource var4);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J,\u0010\b\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J&\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cR\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/possible_triangle/sliceanddice/block/sprinkler/SprinkleBehaviour$Companion;", "", "<init>", "()V", "BEHAVIOURS", "Ljava/util/ArrayList;", "Lcom/possible_triangle/sliceanddice/block/sprinkler/RegisteredBehaviour;", "Lkotlin/collections/ArrayList;", "register", "", "tag", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/material/Fluid;", "behaviour", "Lcom/possible_triangle/sliceanddice/block/sprinkler/SprinkleBehaviour;", "rangeBonus", "", "predicate", "Lkotlin/Function1;", "Lnet/neoforged/neoforge/fluids/FluidStack;", "", "actAt", "pos", "Lnet/minecraft/core/BlockPos;", "world", "Lnet/minecraft/server/level/ServerLevel;", "fluid", "random", "Lnet/minecraft/util/RandomSource;", "sliceanddice-forge-4.1.2"})
    @SourceDebugExtension(value={"SMAP\nSprinkleBehaviour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SprinkleBehaviour.kt\ncom/possible_triangle/sliceanddice/block/sprinkler/SprinkleBehaviour$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n774#2:111\n865#2,2:112\n1869#2,2:114\n*S KotlinDebug\n*F\n+ 1 SprinkleBehaviour.kt\ncom/possible_triangle/sliceanddice/block/sprinkler/SprinkleBehaviour$Companion\n*L\n101#1:111\n101#1:112,2\n101#1:114,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ArrayList<RegisteredBehaviour> BEHAVIOURS;

        private Companion() {
        }

        public final void register(@NotNull TagKey<Fluid> tag, @NotNull SprinkleBehaviour behaviour, int rangeBonus) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
            this.register((Function1<? super FluidStack, Boolean>)((Function1)arg_0 -> Companion.register$lambda$0(tag, arg_0)), behaviour, rangeBonus);
        }

        public static /* synthetic */ void register$default(Companion companion, TagKey tagKey, SprinkleBehaviour sprinkleBehaviour, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            companion.register((TagKey<Fluid>)tagKey, sprinkleBehaviour, n);
        }

        public final void register(@NotNull Function1<? super FluidStack, Boolean> predicate, @NotNull SprinkleBehaviour behaviour, int rangeBonus) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
            BEHAVIOURS.add(new RegisteredBehaviour(predicate, behaviour, rangeBonus));
        }

        public static /* synthetic */ void register$default(Companion companion, Function1 function1, SprinkleBehaviour sprinkleBehaviour, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            companion.register((Function1<? super FluidStack, Boolean>)function1, sprinkleBehaviour, n);
        }

        /*
         * WARNING - void declaration
         */
        public final void actAt(@NotNull BlockPos pos, @NotNull ServerLevel world, @NotNull FluidStack fluid, @NotNull RandomSource random) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            Iterable $this$filter$iv = BEHAVIOURS;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RegisteredBehaviour it = (RegisteredBehaviour)element$iv$iv;
                boolean bl = false;
                if (!((Boolean)it.getPredicate().invoke((Object)fluid)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RegisteredBehaviour it = (RegisteredBehaviour)element$iv;
                boolean bl = false;
                Integer radius = (Integer)Configs.INSTANCE.getSERVER().getSPRINKLER_RANGE().get();
                Vec3i area = new Vec3i(radius + it.getRangeBonus(), 7, radius + it.getRangeBonus());
                Range range = new Range(area, pos, world);
                it.getBehaviour().act(range, world, fluid, random);
            }
        }

        private static final boolean register$lambda$0(TagKey $tag, FluidStack it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getFluid().is($tag);
        }

        static {
            $$INSTANCE = new Companion();
            BEHAVIOURS = new ArrayList();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ:\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00132\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u00160\u0015J\u001a\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0015J\u001a\u0010\u001a\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/possible_triangle/sliceanddice/block/sprinkler/SprinkleBehaviour$Range;", "", "size", "Lnet/minecraft/core/Vec3i;", "origin", "Lnet/minecraft/core/BlockPos;", "world", "Lnet/minecraft/server/level/ServerLevel;", "<init>", "(Lnet/minecraft/core/Vec3i;Lnet/minecraft/core/BlockPos;Lnet/minecraft/server/level/ServerLevel;)V", "aabb", "Lnet/minecraft/world/phys/AABB;", "getAabb", "()Lnet/minecraft/world/phys/AABB;", "getEntities", "", "T", "Lnet/minecraft/world/entity/Entity;", "clazz", "Ljava/lang/Class;", "predicate", "Lkotlin/Function1;", "", "forEachBlock", "", "consumer", "forEachGroundBlock", "sliceanddice-forge-4.1.2"})
    public static final class Range {
        @NotNull
        private final ServerLevel world;
        @NotNull
        private final AABB aabb;

        public Range(@NotNull Vec3i size, @NotNull BlockPos origin, @NotNull ServerLevel world) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            this.world = world;
            this.aabb = new AABB((double)origin.getX() - (double)size.getX() / 2.0, (double)origin.getY() - (double)size.getY(), (double)origin.getZ() - (double)size.getZ() / 2.0, (double)origin.getX() + (double)size.getX() / 2.0, (double)origin.getY() - 1.0, (double)origin.getZ() + (double)size.getZ() / 2.0);
        }

        @NotNull
        public final AABB getAabb() {
            return this.aabb;
        }

        @NotNull
        public final <T extends Entity> List<T> getEntities(@NotNull Class<T> clazz, @NotNull Function1<? super T, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            List list = this.world.getEntities(EntityTypeTest.forClass(clazz), this.aabb, arg_0 -> Range.getEntities$lambda$1(predicate, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
            return list;
        }

        public static /* synthetic */ List getEntities$default(Range range, Class clazz, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = Range::getEntities$lambda$0;
            }
            return range.getEntities(clazz, function1);
        }

        public final void forEachBlock(@NotNull Function1<? super BlockPos, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            for (BlockPos block : BlockPos.betweenClosed((int)((int)Math.ceil(this.aabb.minX)), (int)((int)Math.ceil(this.aabb.minY)), (int)((int)Math.ceil(this.aabb.minZ)), (int)((int)Math.floor(this.aabb.maxX)), (int)((int)Math.floor(this.aabb.maxY)), (int)((int)Math.floor(this.aabb.maxZ)))) {
                Intrinsics.checkNotNull((Object)block);
                consumer.invoke((Object)block);
            }
        }

        public final void forEachGroundBlock(@NotNull Function1<? super BlockPos, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            int minX = (int)Math.ceil(this.aabb.minX);
            int maxX = (int)Math.floor(this.aabb.maxX);
            int minZ = (int)Math.ceil(this.aabb.minZ);
            int maxZ = (int)Math.floor(this.aabb.maxZ);
            int minY = (int)Math.ceil(this.aabb.minY);
            int maxY = (int)Math.floor(this.aabb.maxY);
            int x = minX;
            if (x <= maxX) {
                while (true) {
                    int z;
                    if ((z = minZ) <= maxZ) {
                        while (true) {
                            int y = maxY + 1;
                            while (y > minY) {
                                BlockPos pos = new BlockPos(x, --y, z);
                                BlockState state = this.world.getBlockState(pos);
                                VoxelShape shape = state.getCollisionShape((BlockGetter)this.world, pos, CollisionContext.empty());
                                if (y == minY) {
                                    consumer.invoke((Object)pos);
                                    break;
                                }
                                if (state.isAir() || shape.isEmpty() || !shape.equals((Object)Shapes.block())) continue;
                                consumer.invoke((Object)pos);
                                break;
                            }
                            if (z == maxZ) break;
                            ++z;
                        }
                    }
                    if (x == maxX) break;
                    ++x;
                }
            }
        }

        private static final boolean getEntities$lambda$0(Entity it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        private static final boolean getEntities$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

