/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.sliceanddice.block.sprinkler;

import com.possible_triangle.sliceanddice.Content;
import com.possible_triangle.sliceanddice.block.sprinkler.SprinkleBehaviour;
import com.possible_triangle.sliceanddice.config.Configs;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J \u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001fH\u0014J\u001e\u0010#\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00122\u0006\u0010&\u001a\u00020\u001fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/possible_triangle/sliceanddice/block/sprinkler/SprinklerBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "Lcom/simibubi/create/api/equipment/goggles/IHaveGoggleInformation;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tank", "Lcom/simibubi/create/foundation/blockEntity/behaviour/fluid/SmartFluidTankBehaviour;", "processingTicks", "", "addBehaviours", "", "behaviours", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "tick", "spawnProcessingParticles", "fluid", "Lnet/neoforged/neoforge/fluids/FluidStack;", "writeSafe", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "read", "clientPacket", "", "write", "compound", "client", "addToGoggleTooltip", "tooltip", "Lnet/minecraft/network/chat/Component;", "sneaking", "Companion", "sliceanddice-forge-4.1.2"})
@SourceDebugExtension(value={"SMAP\nSprinklerBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SprinklerBlockEntity.kt\ncom/possible_triangle/sliceanddice/block/sprinkler/SprinklerBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class SprinklerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private SmartFluidTankBehaviour tank;
    private int processingTicks;

    public SprinklerBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.processingTicks = -1;
    }

    /*
     * WARNING - void declaration
     */
    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        void it;
        SmartFluidTankBehaviour smartFluidTankBehaviour;
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        SmartBlockEntity smartBlockEntity = this;
        Object object = Configs.INSTANCE.getSERVER().getSPRINKLER_CAPACITY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        SmartFluidTankBehaviour smartFluidTankBehaviour2 = smartFluidTankBehaviour = SmartFluidTankBehaviour.single((SmartBlockEntity)smartBlockEntity, (int)((Number)object).intValue()).allowInsertion().whenFluidUpdates(() -> ((SprinklerBlockEntity)this).notifyUpdate());
        List<BlockEntityBehaviour> list = behaviours;
        boolean bl = false;
        this.tank = it;
        SmartFluidTankBehaviour smartFluidTankBehaviour3 = smartFluidTankBehaviour;
        Intrinsics.checkNotNullExpressionValue((Object)smartFluidTankBehaviour3, (String)"also(...)");
        list.add((BlockEntityBehaviour)smartFluidTankBehaviour3);
    }

    public void tick() {
        super.tick();
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level world = level;
        BlockState below = world.getBlockState(this.getBlockPos().below());
        if (below.isFaceSturdy((BlockGetter)world, this.getBlockPos().below(), Direction.UP)) {
            return;
        }
        if (this.processingTicks >= 0) {
            int n = this.processingTicks;
            this.processingTicks = n + -1;
        } else {
            SprinklerBlockEntity $this$tick_u24lambda_u241 = this;
            boolean bl = false;
            Integer used = (Integer)Configs.INSTANCE.getSERVER().getSPRINKLER_USAGE().get();
            SmartFluidTankBehaviour smartFluidTankBehaviour = $this$tick_u24lambda_u241.tank;
            if (smartFluidTankBehaviour == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
                smartFluidTankBehaviour = null;
            }
            IFluidHandler iFluidHandler = smartFluidTankBehaviour.getCapability();
            Intrinsics.checkNotNull((Object)used);
            FluidStack fluid = iFluidHandler.drain(used.intValue(), IFluidHandler.FluidAction.SIMULATE);
            if (fluid.getAmount() >= used) {
                SmartFluidTankBehaviour smartFluidTankBehaviour2 = $this$tick_u24lambda_u241.tank;
                if (smartFluidTankBehaviour2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
                    smartFluidTankBehaviour2 = null;
                }
                smartFluidTankBehaviour2.getCapability().drain(used.intValue(), IFluidHandler.FluidAction.EXECUTE);
                $this$tick_u24lambda_u241.processingTicks = 20;
            }
        }
        if (this.processingTicks >= 8) {
            if (world.isClientSide && !this.isVirtual()) {
                SmartFluidTankBehaviour smartFluidTankBehaviour = this.tank;
                if (smartFluidTankBehaviour == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
                    smartFluidTankBehaviour = null;
                }
                FluidStack fluidStack = smartFluidTankBehaviour.getPrimaryTank().getRenderedFluid();
                Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getRenderedFluid(...)");
                this.spawnProcessingParticles(fluidStack);
            }
            if (world instanceof ServerLevel) {
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                ServerLevel serverLevel = (ServerLevel)world;
                SmartFluidTankBehaviour smartFluidTankBehaviour = this.tank;
                if (smartFluidTankBehaviour == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
                    smartFluidTankBehaviour = null;
                }
                FluidStack fluidStack = smartFluidTankBehaviour.getPrimaryHandler().getFluid();
                Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluid(...)");
                RandomSource randomSource = world.random;
                Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
                SprinkleBehaviour.Companion.actAt(blockPos, serverLevel, fluidStack, randomSource);
            }
        }
    }

    private final void spawnProcessingParticles(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level world = level;
        ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
        double x = world.random.nextDouble() * (double)2 - 1.0;
        double z = world.random.nextDouble() * (double)2 - 1.0;
        Vec3 vec = VecHelper.getCenterOf((Vec3i)((Vec3i)this.getBlockPos())).add(0.0, 0.125, 0.0).add(x * 0.3, 0.0, z * 0.3);
        world.addParticle(particle, vec.x, vec.y, vec.z, x * 0.2, -0.1, z * 0.2);
    }

    public void writeSafe(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.writeSafe(tag, registries);
        tag.putInt("ProcessingTicks", this.processingTicks);
    }

    protected void read(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.read(tag, registries, clientPacket);
        this.processingTicks = tag.getInt("ProcessingTicks");
    }

    protected void write(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider registries, boolean client) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.write(compound, registries, client);
        compound.putInt("ProcessingTicks", this.processingTicks);
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean sneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        SmartFluidTankBehaviour smartFluidTankBehaviour = this.tank;
        if (smartFluidTankBehaviour == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
            smartFluidTankBehaviour = null;
        }
        return this.containedFluidTooltip(tooltip, sneaking, smartFluidTankBehaviour.getCapability());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/possible_triangle/sliceanddice/block/sprinkler/SprinklerBlockEntity$Companion;", "", "<init>", "()V", "registerCapabilities", "", "event", "Lnet/neoforged/neoforge/capabilities/RegisterCapabilitiesEvent;", "sliceanddice-forge-4.1.2"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)Content.INSTANCE.getSPRINKLER_BLOCK_ENTITY().get(), (arg_0, arg_1) -> Companion.registerCapabilities$lambda$1(Companion::registerCapabilities$lambda$0, arg_0, arg_1));
        }

        private static final IFluidHandler registerCapabilities$lambda$0(SprinklerBlockEntity it, Direction direction) {
            SmartFluidTankBehaviour smartFluidTankBehaviour = it.tank;
            if (smartFluidTankBehaviour == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
                smartFluidTankBehaviour = null;
            }
            return smartFluidTankBehaviour.getCapability();
        }

        private static final IFluidHandler registerCapabilities$lambda$1(Function2 $tmp0, Object p0, Direction p1) {
            return (IFluidHandler)$tmp0.invoke(p0, (Object)p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

