/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.sliceanddice.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.possible_triangle.sliceanddice.Content;
import com.possible_triangle.sliceanddice.SlicerPartials;
import com.possible_triangle.sliceanddice.recipe.CuttingProcessingRecipe;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bJ \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/possible_triangle/sliceanddice/compat/jei/AnimatedSlicer;", "Lcom/simibubi/create/compat/jei/category/animations/AnimatedKinetics;", "basin", "", "<init>", "(Z)V", "held", "Lnet/minecraft/world/item/ItemStack;", "setRecipe", "", "recipe", "Lcom/simibubi/create/content/processing/recipe/ProcessingRecipe;", "draw", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "x", "", "y", "sliceanddice-forge-4.1.2"})
public final class AnimatedSlicer
extends AnimatedKinetics {
    private final boolean basin;
    @NotNull
    private ItemStack held;

    public AnimatedSlicer(boolean basin) {
        this.basin = basin;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.held = itemStack;
    }

    public final void setRecipe(@NotNull ProcessingRecipe<?, ?> recipe) {
        Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
        if (recipe instanceof CuttingProcessingRecipe) {
            Object[] objectArray = ((CuttingProcessingRecipe)recipe).getParams().getTool();
            ItemStack stack = objectArray != null && (objectArray = objectArray.getItems()) != null ? (ItemStack)ArraysKt.firstOrNull((Object[])objectArray) : null;
            ItemStack itemStack = stack;
            if (itemStack == null) {
                ItemStack itemStack2 = ItemStack.EMPTY;
                itemStack = itemStack2;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            }
            this.held = itemStack;
        }
    }

    public void draw(@NotNull GuiGraphics graphics, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)x, (float)y, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        int scale = this.basin ? 23 : 24;
        this.blockElement(this.cogwheel()).rotateBlock(0.0, (double)(AnimatedKinetics.getCurrentAngle() * 2.0f), 0.0).atLocal(0.0, 0.0, 0.0).scale((double)scale).render(graphics);
        this.blockElement(Content.INSTANCE.getSLICER_BLOCK().getDefaultState()).atLocal(0.0, 0.0, 0.0).scale((double)scale).render(graphics);
        float animation = (Mth.sin((float)(AnimationTickHolder.getRenderTime() / 4.0f)) + 1.0f) / 5.0f + 0.5f;
        this.blockElement(AllPartialModels.MECHANICAL_MIXER_POLE).atLocal(0.0, (double)animation, 0.0).scale((double)scale).render(graphics);
        float angle = AnimatedKinetics.getCurrentAngle() * 4.0f;
        this.blockElement(SlicerPartials.INSTANCE.getSLICER_HEAD()).rotateBlock(0.0, (double)angle, 0.0).atLocal(0.0, (double)animation, 0.0).scale((double)scale).render(graphics);
        if (this.basin) {
            this.blockElement(AllBlocks.BASIN.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale((double)scale).render(graphics);
        }
        if (!this.held.isEmpty()) {
            matrixStack.pushPose();
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            float toolScale = (float)scale * 0.7f;
            matrixStack.scale(toolScale, toolScale, toolScale);
            matrixStack.translate(1.0f, animation + 0.4f, 0.0f);
            for (int i = 0; i < 4; ++i) {
                matrixStack.pushPose();
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f * (float)i));
                matrixStack.mulPose(Axis.YP.rotationDegrees(angle));
                matrixStack.mulPose(Axis.ZN.rotationDegrees(20.0f));
                matrixStack.translate(0.0, 0.0, 0.4);
                ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
                renderer.renderStatic(this.held, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, matrixStack, (MultiBufferSource)buffer, null, 0);
                matrixStack.popPose();
            }
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }
}

