/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.data;

import com.cobblemon.mod.common.api.conditional.RegistryLikeCondition;
import com.cobblemon.mod.common.api.conditional.RegistryLikeIdentifierCondition;
import com.cobblemon.mod.common.api.conditional.RegistryLikeTagCondition;
import com.cobblemon.mod.common.api.net.Encodable;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.evolution.variants.ItemInteractionEvolution;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\f\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\f\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u001d\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/arcaryx/cobblemonintegrations/data/EvoItem;", "Lcom/cobblemon/mod/common/api/net/Encodable;", "species", "Lnet/minecraft/resources/ResourceLocation;", "aspects", "", "", "evolution", "Lcom/cobblemon/mod/common/pokemon/evolution/variants/ItemInteractionEvolution;", "evolutionJson", "evoSpecies", "evoAspects", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/Set;Lcom/cobblemon/mod/common/pokemon/evolution/variants/ItemInteractionEvolution;Ljava/lang/String;Lnet/minecraft/resources/ResourceLocation;Ljava/util/Set;)V", "buffer", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "getSpecies", "()Lnet/minecraft/resources/ResourceLocation;", "getAspects", "()Ljava/util/Set;", "getEvolution", "()Lcom/cobblemon/mod/common/pokemon/evolution/variants/ItemInteractionEvolution;", "setEvolution", "(Lcom/cobblemon/mod/common/pokemon/evolution/variants/ItemInteractionEvolution;)V", "getEvoSpecies", "getEvoAspects", "encode", "", "fixJson", "SerializerFix", "cobblemonintegrations-common-1.21.1"})
public final class EvoItem
implements Encodable {
    @NotNull
    private final ResourceLocation species;
    @NotNull
    private final Set<String> aspects;
    @Nullable
    private ItemInteractionEvolution evolution;
    @Nullable
    private final String evolutionJson;
    @NotNull
    private final ResourceLocation evoSpecies;
    @NotNull
    private final Set<String> evoAspects;

    public EvoItem(@NotNull ResourceLocation species, @NotNull Set<String> aspects, @Nullable ItemInteractionEvolution evolution, @Nullable String evolutionJson, @NotNull ResourceLocation evoSpecies, @NotNull Set<String> evoAspects) {
        Intrinsics.checkNotNullParameter((Object)species, (String)"species");
        Intrinsics.checkNotNullParameter(aspects, (String)"aspects");
        Intrinsics.checkNotNullParameter((Object)evoSpecies, (String)"evoSpecies");
        Intrinsics.checkNotNullParameter(evoAspects, (String)"evoAspects");
        this.species = species;
        this.aspects = aspects;
        this.evolution = evolution;
        this.evolutionJson = evolutionJson;
        this.evoSpecies = evoSpecies;
        this.evoAspects = evoAspects;
    }

    @NotNull
    public final ResourceLocation getSpecies() {
        return this.species;
    }

    @NotNull
    public final Set<String> getAspects() {
        return this.aspects;
    }

    @Nullable
    public final ItemInteractionEvolution getEvolution() {
        return this.evolution;
    }

    public final void setEvolution(@Nullable ItemInteractionEvolution itemInteractionEvolution) {
        this.evolution = itemInteractionEvolution;
    }

    @NotNull
    public final ResourceLocation getEvoSpecies() {
        return this.evoSpecies;
    }

    @NotNull
    public final Set<String> getEvoAspects() {
        return this.evoAspects;
    }

    public EvoItem(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ResourceLocation resourceLocation = buffer.readResourceLocation();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"readResourceLocation(...)");
        List list = buffer.readList(arg_0 -> EvoItem._init_$lambda$1(arg_0 -> EvoItem._init_$lambda$0(buffer, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        Set set = CollectionsKt.toSet((Iterable)list);
        String string = BufferUtilsKt.readString((ByteBuf)((ByteBuf)buffer));
        ResourceLocation resourceLocation2 = buffer.readResourceLocation();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"readResourceLocation(...)");
        List list2 = buffer.readList(arg_0 -> EvoItem._init_$lambda$3(arg_0 -> EvoItem._init_$lambda$2(buffer, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"readList(...)");
        this(resourceLocation, set, null, string, resourceLocation2, CollectionsKt.toSet((Iterable)list2));
    }

    public void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeResourceLocation(this.species);
        buffer.writeCollection((Collection)this.aspects, (arg_0, arg_1) -> EvoItem.encode$lambda$5((arg_0, arg_1) -> EvoItem.encode$lambda$4(buffer, arg_0, arg_1), arg_0, arg_1));
        Gson gson = PokemonSpecies.INSTANCE.getGson().newBuilder().registerTypeHierarchyAdapter(RegistryLikeCondition.class, new SerializerFix()).create();
        ByteBuf byteBuf = (ByteBuf)buffer;
        String string = gson.toJson((Object)this.evolution);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        BufferUtilsKt.writeString((ByteBuf)byteBuf, (String)string);
        buffer.writeResourceLocation(this.evoSpecies);
        buffer.writeCollection((Collection)this.evoAspects, (arg_0, arg_1) -> EvoItem.encode$lambda$7((arg_0, arg_1) -> EvoItem.encode$lambda$6(buffer, arg_0, arg_1), arg_0, arg_1));
    }

    public final void fixJson() {
        if (this.evolution == null) {
            this.evolution = (ItemInteractionEvolution)PokemonSpecies.INSTANCE.getGson().fromJson(this.evolutionJson, ItemInteractionEvolution.class);
        }
    }

    private static final String _init_$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        return BufferUtilsKt.readString((ByteBuf)((ByteBuf)$buffer));
    }

    private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String _init_$lambda$2(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        return BufferUtilsKt.readString((ByteBuf)((ByteBuf)$buffer));
    }

    private static final String _init_$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit encode$lambda$4(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf pb, String value) {
        ByteBuf byteBuf = (ByteBuf)$buffer;
        Intrinsics.checkNotNull((Object)value);
        BufferUtilsKt.writeString((ByteBuf)byteBuf, (String)value);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$5(Function2 $tmp0, Object p0, String p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit encode$lambda$6(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf pb, String value) {
        ByteBuf byteBuf = (ByteBuf)$buffer;
        Intrinsics.checkNotNull((Object)value);
        BufferUtilsKt.writeString((ByteBuf)byteBuf, (String)value);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$7(Function2 $tmp0, Object p0, String p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/arcaryx/cobblemonintegrations/data/EvoItem$SerializerFix;", "B", "Lcom/google/gson/JsonSerializer;", "Lcom/cobblemon/mod/common/api/conditional/RegistryLikeCondition;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "cobblemonintegrations-common-1.21.1"})
    private static final class SerializerFix<B>
    implements JsonSerializer<RegistryLikeCondition<B>> {
        @NotNull
        public JsonElement serialize(@NotNull RegistryLikeCondition<B> src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter(src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (src instanceof RegistryLikeIdentifierCondition) {
                return (JsonElement)new JsonPrimitive(((RegistryLikeIdentifierCondition)src).getIdentifier().toString());
            }
            return (JsonElement)new JsonPrimitive("#" + ((RegistryLikeTagCondition)src).getTag().location());
        }
    }
}

