/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.enhancedcelestials;

import com.arcaryx.cobblemonintegrations.enhancedcelestials.PokemonLunarEvent;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.pokemon.IVs;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001a"}, d2={"Lcom/arcaryx/cobblemonintegrations/enhancedcelestials/EnhancedCelestialsHandler;", "", "<init>", "()V", "isOngoingLunarEvent", "", "level", "Lnet/minecraft/world/level/Level;", "lunarEvent", "Lnet/minecraft/resources/ResourceLocation;", "modifySpawns", "", "props", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "ctx", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "modifyBattleExp", "", "baseExp", "modifyBattleEVs", "baseChanges", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "getLunarEventName", "Lnet/minecraft/network/chat/Component;", "eventLocation", "cobblemonintegrations-common-1.21.1"})
public final class EnhancedCelestialsHandler {
    @NotNull
    public static final EnhancedCelestialsHandler INSTANCE = new EnhancedCelestialsHandler();

    private EnhancedCelestialsHandler() {
    }

    public final boolean isOngoingLunarEvent(@NotNull Level level, @NotNull ResourceLocation lunarEvent) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)lunarEvent, (String)"lunarEvent");
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        return lunarForecastWorldData.isPresent() && ((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().is(lunarEvent);
    }

    public final void modifySpawns(@NotNull PokemonProperties props, @NotNull SpawningContext ctx) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ServerLevel level = ctx.getWorld();
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)((Level)level));
        if (lunarForecastWorldData.isPresent()) {
            Registry registry = level.registryAccess().registryOrThrow(PokemonLunarEvent.Companion.getKEY());
            for (PokemonLunarEvent event : registry) {
                if (!((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().is(event.getLunarEvent())) continue;
                if (Cobblemon.INSTANCE.getConfig().getShinyRate() >= 1.0f && event.getShinyMultiplier() > 0.0f) {
                    float modifiedShinyRate = Cobblemon.INSTANCE.getConfig().getShinyRate() / event.getShinyMultiplier();
                    if (Random.Default.nextFloat() < 1.0f / modifiedShinyRate) {
                        props.setShiny(Boolean.valueOf(true));
                    }
                }
                if (event.getPerfIVs() <= 0) break;
                props.setIvs(IVs.Companion.createRandomIVs(event.getPerfIVs()));
                break;
            }
        }
    }

    public final int modifyBattleExp(int baseExp, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        if (lunarForecastWorldData.isPresent()) {
            Registry registry = level.registryAccess().registryOrThrow(PokemonLunarEvent.Companion.getKEY());
            for (PokemonLunarEvent event : registry) {
                if (!((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().is(event.getLunarEvent())) continue;
                return MathKt.roundToInt((float)((float)baseExp * event.getExpMultiplier()));
            }
        }
        return baseExp;
    }

    public final void modifyBattleEVs(@NotNull Map<Stat, Integer> baseChanges, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(baseChanges, (String)"baseChanges");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        if (lunarForecastWorldData.isPresent()) {
            Registry registry = level.registryAccess().registryOrThrow(PokemonLunarEvent.Companion.getKEY());
            for (PokemonLunarEvent event : registry) {
                if (!((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().is(event.getLunarEvent())) continue;
                for (Stat stat : baseChanges.keySet()) {
                    Integer n = baseChanges.get(stat);
                    int base = n != null ? n : 0;
                    baseChanges.put(stat, MathKt.roundToInt((float)((float)Math.ceil((float)base * event.getEvMultiplier()))));
                }
            }
        }
    }

    @NotNull
    public final Component getLunarEventName(@NotNull ResourceLocation eventLocation, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)eventLocation, (String)"eventLocation");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Registry registry = level.registryAccess().registryOrThrow(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        Registry lunarEventRegistry = registry;
        LunarEvent lunarEvent = (LunarEvent)lunarEventRegistry.get(eventLocation);
        if (lunarEvent != null) {
            Component component = lunarEvent.getTextComponents().name().getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
            return component;
        }
        MutableComponent mutableComponent = Component.literal((String)eventLocation.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return (Component)mutableComponent;
    }
}

