/*
 * Decompiled with CFR 0.152.
 */
package necro.crd.broadcasts.common.mixin;

import necro.crd.broadcasts.common.util.IRemoter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
implements IRemoter {
    @Unique
    private Vec3 crdb_originalPos;

    @Override
    public Vec3 crdb_getOriginalPos() {
        return this.crdb_originalPos;
    }

    @Override
    public void crdb_setOriginalPos(Vec3 originalPos) {
        this.crdb_originalPos = originalPos;
    }

    @Override
    public void crdb_clearOriginalPos() {
        this.crdb_originalPos = null;
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    public void addAdditionalSaveDataInject(CompoundTag compoundTag, CallbackInfo ci) {
        if (this.crdb_originalPos == null) {
            return;
        }
        compoundTag.putDouble("crdb_pos_x", this.crdb_originalPos.x());
        compoundTag.putDouble("crdb_pos_y", this.crdb_originalPos.y());
        compoundTag.putDouble("crdb_pos_z", this.crdb_originalPos.z());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    public void readAdditionalSaveDataInject(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.contains("crdb_pos_x")) {
            double x = compoundTag.getDouble("crdb_pos_x");
            double y = compoundTag.getDouble("crdb_pos_y");
            double z = compoundTag.getDouble("crdb_pos_z");
            this.crdb_originalPos = new Vec3(x, y, z);
        }
    }
}

