/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.utils.Textures;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;

public final class MoreCobblemonTweaks {
    public static final String MOD_ID = "more_cobblemon_tweaks";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static File configFile;

    public static void initClient(File configFile, Function<String, Boolean> modEnabledFunction, Function<String, String> modVersionFunction) {
        LOGGER.info("Starting MoreCobblemonTweaks");
        MoreCobblemonTweaks.configFile = configFile;
        Utils.setModEnabledFunction(modEnabledFunction);
        Utils.setModVersionFunction(modVersionFunction);
    }

    public static void onReload(ResourceManager manager) {
        ModConfig.loadFromFile();
        Textures.POSSIBLE_WALLPAPER_TEXTURES.clear();
        for (ResourceLocation wallpaper : manager.listResourceStacks("textures/gui/pc/wallpapers", identifier -> true).keySet()) {
            String path = wallpaper.getPath();
            String shortName = path.substring(path.lastIndexOf(47) + 1, path.indexOf(46));
            Textures.POSSIBLE_WALLPAPER_TEXTURES.put(shortName, wallpaper);
        }
        PackRepository resourcePackManager = Minecraft.getInstance().getResourcePackRepository();
        List<String> serverPackIds = resourcePackManager.getSelectedPacks().stream().filter(pack -> pack.getPackSource() == PackSource.SERVER).map(Pack::getId).toList();
        for (Map.Entry entry : manager.listResourceStacks("config", identifier -> identifier.getPath().equals("config/more_cobblemon_tweaks.json")).entrySet()) {
            for (Resource resource : (List)entry.getValue()) {
                if (!serverPackIds.contains(resource.sourcePackId())) continue;
                try {
                    ModConfig.loadServerConfig(resource.openAsReader());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load server config file \"{}\" from pack \"{}\"", entry.getKey(), (Object)resource.sourcePackId());
                    LOGGER.error("Error: ", (Throwable)e);
                }
            }
        }
    }

    public static String getCurrentServerId() {
        IntegratedServer integratedServer = Minecraft.getInstance().getSingleplayerServer();
        if (integratedServer != null) {
            Object rootId = integratedServer.getWorldPath(LevelResource.ROOT).getParent().getFileName().toString().replaceAll("_", "^us^");
            if (((String)rootId).startsWith("Multiplayer_")) {
                rootId = "^e^" + (String)rootId;
            }
            rootId = ((String)rootId).replace("[", "%lb%").replace("]", "%rb%");
            return rootId;
        }
        ServerData data = Minecraft.getInstance().getCurrentServer();
        return data != null ? data.ip : "unknown";
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.tryBuild((String)MOD_ID, (String)path);
    }

    public static File getConfigFile() {
        return configFile;
    }
}

