/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import me.justahuman.more_cobblemon_tweaks.MoreCobblemonTweaks;
import me.justahuman.more_cobblemon_tweaks.utils.Textures;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ModConfig {
    private static final Gson GSON = new Gson().newBuilder().setPrettyPrinting().create();
    private static final JsonObject INTERNAL_CONFIG = new JsonObject();
    private static final JsonObject SERVER_CONFIG = new JsonObject();
    private static final JsonObject DEFAULT_CONFIG = new JsonObject();
    private static final Map<Integer, Component> BOX_NAME_CACHE = new HashMap<Integer, Component>();
    private static final Map<Integer, ResourceLocation> WALLPAPER_CACHE = new HashMap<Integer, ResourceLocation>();
    private static String lastServerId = "";

    public static void loadFromFile() {
        INTERNAL_CONFIG.asMap().clear();
        WALLPAPER_CACHE.clear();
        BOX_NAME_CACHE.clear();
        try (FileReader reader = new FileReader(ModConfig.getConfigFile());){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                jsonObject.entrySet().forEach(entry -> INTERNAL_CONFIG.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            }
        }
        catch (Exception e) {
            MoreCobblemonTweaks.LOGGER.warn("Error occurred while loading Config!");
            MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
        }
    }

    public static void clearServerConfig() {
        SERVER_CONFIG.asMap().clear();
    }

    public static void loadServerConfig(BufferedReader reader) {
        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            jsonObject.entrySet().forEach(entry -> SERVER_CONFIG.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        }
    }

    public static boolean serverOverride(String option) {
        JsonPrimitive primitive;
        JsonElement jsonElement = SERVER_CONFIG.get(option);
        return jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isBoolean();
    }

    public static boolean isEnabled(String option) {
        JsonPrimitive primitive;
        JsonElement jsonElement = SERVER_CONFIG.get(option);
        if (jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isBoolean()) {
            return primitive.getAsBoolean();
        }
        jsonElement = INTERNAL_CONFIG.get(option);
        return jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isBoolean() ? primitive.getAsBoolean() : DEFAULT_CONFIG.get(option).getAsBoolean();
    }

    public static void setEnabled(String key, boolean value) {
        INTERNAL_CONFIG.addProperty(key, Boolean.valueOf(value));
    }

    public static Component getBoxName(int box) {
        JsonPrimitive primitive;
        JsonObject object;
        JsonObject boxNames;
        JsonObject object2;
        JsonObject serverBoxes;
        Component cache;
        String lastServerId = ModConfig.lastServerId;
        if (!lastServerId.equals(ModConfig.lastServerId = MoreCobblemonTweaks.getCurrentServerId())) {
            BOX_NAME_CACHE.clear();
            WALLPAPER_CACHE.clear();
            Utils.currentBox = 0;
        }
        if ((cache = BOX_NAME_CACHE.get(box)) != null) {
            return cache;
        }
        JsonElement jsonElement = INTERNAL_CONFIG.get("pc_box_names");
        JsonObject jsonObject = serverBoxes = jsonElement instanceof JsonObject ? (object2 = (JsonObject)jsonElement) : null;
        if (serverBoxes == null) {
            BOX_NAME_CACHE.put(box, CommonComponents.EMPTY);
            return null;
        }
        JsonElement jsonElement2 = serverBoxes.get(ModConfig.lastServerId);
        JsonObject jsonObject2 = boxNames = jsonElement2 instanceof JsonObject ? (object = (JsonObject)jsonElement2) : null;
        if (boxNames == null) {
            BOX_NAME_CACHE.put(box, CommonComponents.EMPTY);
            return null;
        }
        JsonElement jsonElement3 = boxNames.get(String.valueOf(box));
        Component name = jsonElement3 instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement3).isString() ? Component.literal((String)primitive.getAsString()).withStyle(ChatFormatting.BOLD) : CommonComponents.EMPTY;
        BOX_NAME_CACHE.put(box, name);
        return name;
    }

    public static void setBoxName(int box, String name) {
        JsonObject object;
        JsonObject boxNames;
        JsonObject object2;
        JsonElement jsonElement = INTERNAL_CONFIG.get("pc_box_names");
        JsonObject serverBoxes = jsonElement instanceof JsonObject ? (object2 = (JsonObject)jsonElement) : new JsonObject();
        JsonElement jsonElement2 = serverBoxes.get(MoreCobblemonTweaks.getCurrentServerId());
        JsonObject jsonObject = boxNames = jsonElement2 instanceof JsonObject ? (object = (JsonObject)jsonElement2) : new JsonObject();
        if (name == null || name.isBlank()) {
            boxNames.remove(String.valueOf(box));
            BOX_NAME_CACHE.put(box, CommonComponents.EMPTY);
        } else {
            boxNames.addProperty(String.valueOf(box), name);
            BOX_NAME_CACHE.put(box, (Component)Component.literal((String)name).withStyle(ChatFormatting.BOLD));
        }
        serverBoxes.add(MoreCobblemonTweaks.getCurrentServerId(), (JsonElement)boxNames);
        INTERNAL_CONFIG.add("pc_box_names", (JsonElement)serverBoxes);
        ModConfig.saveConfig(false);
    }

    public static ResourceLocation getBoxTexture(int box) {
        JsonPrimitive primitive;
        JsonObject object;
        JsonObject wallpapers;
        JsonObject object2;
        JsonObject pcWallpapers;
        ResourceLocation cache;
        String lastServerId = ModConfig.lastServerId;
        if (!lastServerId.equals(ModConfig.lastServerId = MoreCobblemonTweaks.getCurrentServerId())) {
            BOX_NAME_CACHE.clear();
            WALLPAPER_CACHE.clear();
            Utils.currentBox = 0;
        }
        if ((cache = WALLPAPER_CACHE.get(box)) != null) {
            return cache;
        }
        JsonElement jsonElement = INTERNAL_CONFIG.get("pc_wallpapers");
        JsonObject jsonObject = pcWallpapers = jsonElement instanceof JsonObject ? (object2 = (JsonObject)jsonElement) : null;
        if (pcWallpapers == null) {
            WALLPAPER_CACHE.put(box, Textures.WALLPAPER_DEFAULT_TEXTURE);
            return Textures.WALLPAPER_DEFAULT_TEXTURE;
        }
        JsonElement jsonElement2 = pcWallpapers.get(ModConfig.lastServerId);
        JsonObject jsonObject2 = wallpapers = jsonElement2 instanceof JsonObject ? (object = (JsonObject)jsonElement2) : null;
        if (wallpapers == null) {
            WALLPAPER_CACHE.put(box, Textures.WALLPAPER_DEFAULT_TEXTURE);
            return Textures.WALLPAPER_DEFAULT_TEXTURE;
        }
        JsonElement jsonElement3 = wallpapers.get(String.valueOf(box));
        ResourceLocation wallpaper = jsonElement3 instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement3).isString() ? ResourceLocation.parse((String)primitive.getAsString()) : Textures.WALLPAPER_DEFAULT_TEXTURE;
        WALLPAPER_CACHE.put(box, wallpaper);
        return wallpaper;
    }

    public static void setBoxTexture(int box, ResourceLocation texture) {
        JsonObject object;
        JsonObject wallpapers;
        JsonObject object2;
        JsonElement jsonElement = INTERNAL_CONFIG.get("pc_wallpapers");
        JsonObject pcWallpapers = jsonElement instanceof JsonObject ? (object2 = (JsonObject)jsonElement) : new JsonObject();
        JsonElement jsonElement2 = pcWallpapers.get(MoreCobblemonTweaks.getCurrentServerId());
        JsonObject jsonObject = wallpapers = jsonElement2 instanceof JsonObject ? (object = (JsonObject)jsonElement2) : new JsonObject();
        if (Textures.WALLPAPER_DEFAULT_TEXTURE.equals((Object)texture)) {
            wallpapers.remove(String.valueOf(box));
        } else {
            wallpapers.addProperty(String.valueOf(box), texture.toString());
        }
        pcWallpapers.add(MoreCobblemonTweaks.getCurrentServerId(), (JsonElement)wallpapers);
        INTERNAL_CONFIG.add("pc_wallpapers", (JsonElement)pcWallpapers);
        WALLPAPER_CACHE.put(box, texture);
        ModConfig.saveConfig(false);
    }

    public static void saveConfig() {
        ModConfig.saveConfig(true);
    }

    public static void saveConfig(boolean resetCache) {
        if (resetCache) {
            BOX_NAME_CACHE.clear();
            WALLPAPER_CACHE.clear();
        }
        try (FileWriter fileWriter = new FileWriter(ModConfig.getConfigFile());){
            GSON.toJson((JsonElement)INTERNAL_CONFIG, (Appendable)fileWriter);
            fileWriter.flush();
        }
        catch (IOException e) {
            MoreCobblemonTweaks.LOGGER.warn("Error occurred while saving config!");
            MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
        }
    }

    public static File getConfigFile() {
        File configFile = MoreCobblemonTweaks.getConfigFile();
        if (!configFile.exists()) {
            try {
                configFile.getParentFile().mkdirs();
                if (!configFile.createNewFile()) {
                    throw new IOException();
                }
            }
            catch (IOException | SecurityException e) {
                MoreCobblemonTweaks.LOGGER.warn("Failed to create config file!");
                MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
            }
        }
        return configFile;
    }

    public static boolean getDefault(String key) {
        JsonPrimitive primitive;
        JsonElement jsonElement = DEFAULT_CONFIG.get(key);
        return jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isBoolean() && primitive.getAsBoolean();
    }

    static {
        DEFAULT_CONFIG.addProperty("enhanced_egg_lore", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("shiny_egg_indicator", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("perfect_iv_egg_indicator", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("pc_multi_select", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("pc_iv_display", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("pc_colored_ivs", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("open_box_history", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("pc_search", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("pc_search_hide", Boolean.valueOf(false));
        DEFAULT_CONFIG.addProperty("custom_pc_wallpapers", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("custom_pc_box_names", Boolean.valueOf(true));
        DEFAULT_CONFIG.add("pc_wallpapers", (JsonElement)new JsonObject());
        DEFAULT_CONFIG.add("pc_box_names", (JsonElement)new JsonObject());
    }
}

