/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features;

import java.util.List;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.features.egg.EnhancedEggLore;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;

public class LoreEnhancements {
    private static final String BASE_KEY = "more_cobblemon_tweaks.lore_enhancements.";

    public static void enhanceEggLore(List<Component> lore, List<Component> newLore, EnhancedEggLore enhancedEggLore) {
        String gender;
        Component name = enhancedEggLore.getName(lore);
        boolean shiny = enhancedEggLore.isShiny();
        if (ModConfig.isEnabled("shiny_egg_indicator") && shiny) {
            name = name.copy().append((Component)Component.literal((String)" \u2605").withStyle(ChatFormatting.YELLOW));
        }
        if (ModConfig.isEnabled("perfect_iv_egg_indicator") && enhancedEggLore.hasPerfectIVs()) {
            name = name.copy().append((Component)Component.literal((String)" \ud83d\udec6").withStyle(ChatFormatting.YELLOW));
        }
        if ((gender = enhancedEggLore.getGender()).equals("MALE") || gender.equals("FEMALE")) {
            boolean male = gender.equals("MALE");
            name = name.copy().append((Component)Component.literal((String)(male ? " \u2642" : " \u2640")).withStyle(style -> style.withColor(male ? 3329023 : 16536660)));
        }
        lore.set(0, name);
        List<Component> hatchProgress = enhancedEggLore.getHatchProgress(lore);
        boolean spacer = false;
        if (hatchProgress != null && !hatchProgress.isEmpty()) {
            newLore.addAll(hatchProgress);
            spacer = true;
        }
        String nature = enhancedEggLore.getNature();
        String abilityName = enhancedEggLore.getAbility();
        String form = enhancedEggLore.getForm();
        if ((nature != null || abilityName != null || form != null) && spacer) {
            newLore.add((Component)Component.literal((String)" "));
            spacer = false;
        }
        if (nature != null) {
            if (nature.contains(":")) {
                nature = StringUtils.capitalize((String)nature.substring(nature.indexOf(58) + 1));
            }
            newLore.add((Component)LoreEnhancements.translate("egg.nature", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)nature).withStyle(ChatFormatting.WHITE)));
            spacer = true;
        }
        if (abilityName != null) {
            newLore.add((Component)LoreEnhancements.translate("egg.ability", new Object[0]).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)StringUtils.capitalize((String)abilityName)).withStyle(ChatFormatting.WHITE)));
            spacer = true;
        }
        if (form != null) {
            newLore.add((Component)LoreEnhancements.translate("egg.form", new Object[0]).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)StringUtils.capitalize((String)form))));
            spacer = true;
        }
        if (enhancedEggLore.hasIVs()) {
            Integer hp = enhancedEggLore.getHpIV();
            Integer attack = enhancedEggLore.getAtkIV();
            Integer defense = enhancedEggLore.getDefIV();
            Integer spAttack = enhancedEggLore.getSpAtkIV();
            Integer spDefense = enhancedEggLore.getSpDefIV();
            Integer speed = enhancedEggLore.getSpeedIV();
            if (spacer) {
                newLore.add((Component)Component.literal((String)" "));
            }
            if (hp != null && hp != -1) {
                newLore.add((Component)LoreEnhancements.translate("egg.iv.hp", new Object[0]).withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.valueOf(hp)).withStyle(ChatFormatting.WHITE)));
            }
            if (attack != null && attack != -1) {
                newLore.add((Component)LoreEnhancements.translate("egg.iv.attack", new Object[0]).withStyle(ChatFormatting.RED).append((Component)Component.literal((String)String.valueOf(attack)).withStyle(ChatFormatting.WHITE)));
            }
            if (defense != null && defense != -1) {
                newLore.add((Component)LoreEnhancements.translate("egg.iv.defense", new Object[0]).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.valueOf(defense)).withStyle(ChatFormatting.WHITE)));
            }
            if (spAttack != null && spAttack != -1) {
                newLore.add((Component)LoreEnhancements.translate("egg.iv.sp_attack", new Object[0]).withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)String.valueOf(spAttack)).withStyle(ChatFormatting.WHITE)));
            }
            if (spDefense != null && spDefense != -1) {
                newLore.add((Component)LoreEnhancements.translate("egg.iv.sp_defense", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)String.valueOf(spDefense)).withStyle(ChatFormatting.WHITE)));
            }
            if (speed != null && speed != -1) {
                newLore.add((Component)LoreEnhancements.translate("egg.iv.speed", new Object[0]).withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(speed)).withStyle(ChatFormatting.WHITE)));
            }
        }
    }

    public static MutableComponent translate(String key, Object ... args) {
        return Component.translatable((String)(BASE_KEY + key), (Object[])args);
    }
}

