/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.egg;

import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.List;
import me.justahuman.more_cobblemon_tweaks.features.LoreEnhancements;
import me.justahuman.more_cobblemon_tweaks.features.egg.EnhancedEggLore;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class BetterBreedingIntegration
extends EnhancedEggLore {
    private final CompoundTag customData;

    public BetterBreedingIntegration(CompoundTag customData) {
        this.customData = customData;
    }

    @Override
    public Component getName(List<Component> lore) {
        Species species;
        String speciesName = Utils.get(this.customData, "species", "");
        Species species2 = species = speciesName.isBlank() ? PokemonSpecies.INSTANCE.getByPokedexNumber(Utils.get(this.customData, "species", -1), "cobblemon") : PokemonSpecies.INSTANCE.getByName(speciesName);
        if (species != null) {
            return species.getTranslatedName();
        }
        return lore.getFirst();
    }

    @Override
    public boolean isShiny() {
        return Utils.get(this.customData, "shiny", false);
    }

    @Override
    public String getGender() {
        return Utils.get(this.customData, "gender", "NONE");
    }

    @Override
    public List<Component> getHatchProgress(List<Component> lore) {
        int ticks = Utils.get(this.customData, "timer", -1);
        if (ticks != -1) {
            int minutes = (int)Math.floor((double)ticks / 1200.0);
            int seconds = (int)Math.floor((double)(ticks % 1200) / 20.0);
            return List.of(LoreEnhancements.translate("egg.better_breeding.hatch_progress", minutes, seconds));
        }
        return null;
    }

    @Override
    public String getNature() {
        ResourceLocation identifier = ResourceLocation.tryParse((String)Utils.get(this.customData, "nature", ""));
        if (identifier == null) {
            return null;
        }
        Nature nature = Natures.INSTANCE.getNature(identifier);
        if (nature != null) {
            return Component.translatable((String)nature.getDisplayName()).getString();
        }
        return null;
    }

    @Override
    public String getAbility() {
        AbilityTemplate ability;
        String id = Utils.get(this.customData, "ability", null);
        AbilityTemplate abilityTemplate = ability = id == null ? null : Abilities.INSTANCE.get(id);
        if (ability != null) {
            return Component.translatable((String)ability.getDisplayName()).getString();
        }
        return id;
    }

    @Override
    public String getForm() {
        return Utils.get(this.customData, "form", null);
    }

    @Override
    public boolean hasIVs() {
        return this.customData.contains("ivs", 11);
    }

    @Override
    public Integer getHpIV() {
        return this.customData.getIntArray("ivs")[0];
    }

    @Override
    public Integer getAtkIV() {
        return this.customData.getIntArray("ivs")[1];
    }

    @Override
    public Integer getDefIV() {
        return this.customData.getIntArray("ivs")[2];
    }

    @Override
    public Integer getSpAtkIV() {
        return this.customData.getIntArray("ivs")[3];
    }

    @Override
    public Integer getSpDefIV() {
        return this.customData.getIntArray("ivs")[4];
    }

    @Override
    public Integer getSpeedIV() {
        return this.customData.getIntArray("ivs")[5];
    }

    public static BetterBreedingIntegration get(ItemStack itemStack) {
        CompoundTag tag;
        CustomData customData = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && (tag = customData.getUnsafe()).contains("species", 8) && tag.contains("timer", 3)) {
            return new BetterBreedingIntegration(tag);
        }
        return null;
    }
}

