/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.pc.search;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.justahuman.more_cobblemon_tweaks.features.pc.search.predicates.EggGroupPredicate;
import me.justahuman.more_cobblemon_tweaks.features.pc.search.predicates.SimplePredicate;

@FunctionalInterface
public interface SearchPredicate {
    public static final Set<SearchPredicate> ALL = new HashSet<SearchPredicate>();
    public static final Map<String, SearchPredicate> FIXED = new HashMap<String, SearchPredicate>();
    public static final SearchPredicate HOLDING = new SimplePredicate(List.of("holding", "helditem", "held_item"), pokemon -> !pokemon.heldItem().isEmpty());
    public static final SearchPredicate FAINTED = new SimplePredicate(List.of("fainted"), Pokemon::isFainted);
    public static final SearchPredicate LEGENDARY = new SimplePredicate(List.of("legendary"), Pokemon::isLegendary);
    public static final SearchPredicate MYTHICAL = new SimplePredicate(List.of("mythical"), Pokemon::isMythical);
    public static final SearchPredicate ULTRA_BEAST = new SimplePredicate(List.of("ultrabeast", "ultra_beast"), Pokemon::isUltraBeast);
    public static final SearchPredicate EGG_GROUP = new EggGroupPredicate();

    default public void suggest(SuggestionsBuilder builder) {
    }

    public boolean passes(Pokemon var1);

    default public SearchPredicate invert() {
        return pokemon -> !this.passes(pokemon);
    }

    public static void register(SearchPredicate predicate) {
        ALL.add(predicate);
    }

    public static void register(SearchPredicate predicate, List<String> autocomplete) {
        SearchPredicate.register(predicate);
        for (String name : autocomplete) {
            FIXED.put(name, predicate);
        }
    }
}

