/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.pc.search;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.pokemon.Species;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.justahuman.more_cobblemon_tweaks.features.PcEnhancements;
import me.justahuman.more_cobblemon_tweaks.features.pc.search.Search;
import me.justahuman.more_cobblemon_tweaks.features.pc.search.SearchPredicate;
import me.justahuman.more_cobblemon_tweaks.mixins.EditBoxAccessor;
import me.justahuman.more_cobblemon_tweaks.utils.CustomTextField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class SearchWidget
extends CustomTextField {
    private static final CommandContext<?> DUMMY_CONTEXT = new CommandContext(null, null, null, null, null, null, null, null, null, false);
    private static final List<String> IGNORED_SUGGESTIONS = PokemonSpecies.INSTANCE.getSpecies().stream().map(Species::getResourceIdentifier).map(id -> id.getNamespace().equals("cobblemon") ? id.getPath() : id.toString()).toList();
    private String search = "";
    private String suggestion = "";

    public SearchWidget(int x, int y) {
        super(x, y);
        this.setVisible(false);
        this.setBordered(false);
        this.setHint((Component)PcEnhancements.translate("pc_search.blank", new Object[0]).withStyle(ChatFormatting.GRAY));
        this.setResponder(string -> {
            this.search = string.trim().toLowerCase();
            this.suggestion = "";
            Search.instance = null;
            if (this.search.isBlank()) {
                return;
            }
            Search.instance = Search.of(this.search);
            int start = this.search.lastIndexOf(32) + 1;
            if (this.search.length() > start && this.search.charAt(start) == '!') {
                ++start;
            }
            SuggestionsBuilder builder = new SuggestionsBuilder(this.search, start);
            SuggestionsBuilder additionalBuilder = new SuggestionsBuilder(this.search, start);
            SuggestionsBuilder ignoredBuilder = new SuggestionsBuilder(this.search, start);
            for (SearchPredicate predicate : SearchPredicate.ALL) {
                predicate.suggest(additionalBuilder);
            }
            for (String ignored : IGNORED_SUGGESTIONS) {
                ignoredBuilder.suggest(ignored);
            }
            CompletableFuture.supplyAsync(() -> ((SuggestionsBuilder)additionalBuilder).build()).thenAcceptAsync(suggestions -> {
                if (!this.trySetSuggestion((Suggestions)suggestions)) {
                    CompletableFuture.supplyAsync(() -> (Suggestions)PokemonPropertiesArgumentType.Companion.properties().listSuggestions(DUMMY_CONTEXT, builder).join()).thenComposeAsync(propertiesSuggestions -> CompletableFuture.supplyAsync(() -> ((SuggestionsBuilder)ignoredBuilder).build()).thenAcceptAsync(ignored -> {
                        propertiesSuggestions.getList().removeAll(ignored.getList());
                        this.trySetSuggestion((Suggestions)propertiesSuggestions);
                    }));
                }
            });
        });
    }

    public boolean trySetSuggestion(Suggestions suggestions) {
        for (Suggestion suggestion : suggestions.getList()) {
            String text = suggestion.getText().trim();
            Object applied = suggestion.apply(this.search).trim();
            if (((String)applied).length() <= this.search.length() || !((String)applied).startsWith(this.search)) continue;
            if (!text.contains("=") && !SearchPredicate.FIXED.containsKey(text)) {
                applied = (String)applied + "=";
            }
            this.suggestion = applied;
            return true;
        }
        return false;
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int cursorPosition = this.getCursorPosition();
        if (this.isFocused() && !this.suggestion.isBlank() && cursorPosition == this.search.length()) {
            ((EditBoxAccessor)((Object)this)).setDirectValue(this.suggestion);
            this.setTextColor(0xAAAAAA);
            this.setFocused(false);
            super.renderWidget(context, mouseX, mouseY, delta);
            ((EditBoxAccessor)((Object)this)).setDirectValue(this.search);
            this.setTextColor(0xFFFFFF);
            this.setCursorPosition(cursorPosition);
            this.setFocused(true);
        }
        super.renderWidget(context, mouseX, mouseY, delta);
    }

    public void fillSuggestion() {
        this.setValue(this.suggestion);
    }
}

