/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.pc.wallpaper;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.client.storage.ClientPC;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.Objects;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.features.pc.wallpaper.WallpaperButton;
import me.justahuman.more_cobblemon_tweaks.utils.Textures;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WallpaperWidget
extends ObjectSelectionList<Entry> {
    protected static final int ENTRY_WIDTH = 156;
    protected static final int ENTRY_HEIGHT = 142;
    protected final ClientPC pc;
    protected final WallpaperButton button;

    public WallpaperWidget(ClientPC pc, WallpaperButton button, int x, int y) {
        super(Minecraft.getInstance(), 174, 155, y, 142);
        this.pc = pc;
        this.button = button;
        this.centerListVertically = false;
        this.visible = false;
        this.setRenderHeader(false, 0);
        this.setX(x);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            for (Map.Entry<String, ResourceLocation> entry : Textures.POSSIBLE_WALLPAPER_TEXTURES.entrySet()) {
                this.addEntry((AbstractSelectionList.Entry)new Entry(entry.getKey(), entry.getValue()));
            }
            this.visible = true;
        } else {
            this.clearEntries();
            this.visible = false;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.visible && this.isMouseOver(mouseX, mouseY) && this.getHovered() != null) {
            Utils.playSound(CobblemonSounds.PC_CLICK);
            ((Entry)this.getHovered()).mouseClicked(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    protected void renderListItems(GuiGraphics context, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            int top = this.getRowTop(i) + 2;
            int bottom = top + 142;
            if (bottom < this.getY() || top > this.getBottom() - 2) continue;
            this.renderItem(context, mouseX, mouseY, delta, i, this.getX() + this.width / 2 - 78, top, 156, 142);
        }
    }

    protected int getScrollbarPosition() {
        return this.getRight();
    }

    public class Entry
    extends ObjectSelectionList.Entry<Entry> {
        protected final String name;
        protected final ResourceLocation wallpaper;

        public Entry(String name, ResourceLocation wallpaper) {
            this.name = name;
            this.wallpaper = wallpaper;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            RenderSystem.enableBlend();
            if (hovered) {
                Font font = Minecraft.getInstance().font;
                Objects.requireNonNull(font);
                if (y + 9 + 2 > WallpaperWidget.this.getY()) {
                    MutableComponent mutableComponent = Component.literal((String)this.name);
                    Objects.requireNonNull(font);
                    graphics.renderTooltip(font, (Component)mutableComponent, x, y + 9 + 2);
                }
                RenderSystem.disableBlend();
                graphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
            }
            graphics.blit(this.wallpaper, x, y, entryWidth, entryHeight, 0.0f, 0.0f, 208, 189, 208, 189);
            RenderSystem.enableBlend();
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean all = Utils.allBoxes || Screen.hasControlDown();
            ModConfig.setBoxTexture(Utils.currentBox, this.wallpaper);
            if (all) {
                try {
                    for (int i = 0; i < WallpaperWidget.this.pc.getBoxes().size(); ++i) {
                        ModConfig.setBoxTexture(i, this.wallpaper);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            WallpaperWidget.this.button.onClick(mouseX, mouseY);
            return false;
        }

        @NotNull
        public Component getNarration() {
            return Component.empty();
        }
    }
}

