/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.mixins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.justahuman.more_cobblemon_tweaks.Hooks;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.features.LoreEnhancements;
import me.justahuman.more_cobblemon_tweaks.features.egg.BetterBreedingIntegration;
import me.justahuman.more_cobblemon_tweaks.features.egg.CobbreedingIntegration;
import me.justahuman.more_cobblemon_tweaks.features.egg.EnhancedEggLore;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class}, priority=1000000)
public abstract class ItemStackMixin {
    @Inject(method={"getTooltipLines(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, at={@At(value="RETURN")}, cancellable=true)
    public void changeTooltip(Item.TooltipContext tooltipContext, Player player, TooltipFlag tooltipFlag, CallbackInfoReturnable<List<Component>> cir) {
        ArrayList<Component> lore = new ArrayList<Component>((Collection)cir.getReturnValue());
        if (lore.isEmpty()) {
            return;
        }
        ItemStack itemStack = this.moreCobblemonTweaks$cast();
        ArrayList<Component> newLore = new ArrayList<Component>();
        if (ModConfig.isEnabled("enhanced_egg_lore")) {
            EnhancedEggLore wrapper = null;
            if (Hooks.cobbreedingCompat()) {
                wrapper = CobbreedingIntegration.get(itemStack);
            }
            if (wrapper == null) {
                wrapper = BetterBreedingIntegration.get(itemStack);
            }
            if (wrapper != null) {
                LoreEnhancements.enhanceEggLore(lore, newLore, wrapper);
            }
        }
        lore.addAll(1, newLore);
        cir.setReturnValue(lore);
    }

    @Unique
    private ItemStack moreCobblemonTweaks$cast() {
        return (ItemStack)this;
    }
}

