/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.settings;

import com.cobblemon.mod.common.util.adapters.IntRangeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.client.settings.Settings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0005\u001a\u00020\u0004*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\u000b\u001a\u00020\n\"\u000e\b\u0000\u0010\b*\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ9\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u000e\b\u0000\u0010\b*\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/metacontent/cobblenav/client/settings/ClientSettingsDataManager;", "", "<init>", "()V", "", "toPath", "(Ljava/lang/String;)Ljava/lang/String;", "Lcom/metacontent/cobblenav/client/settings/Settings;", "T", "settings", "", "save", "(Lcom/metacontent/cobblenav/client/settings/Settings;)V", "name", "Ljava/lang/Class;", "clazz", "load", "(Ljava/lang/String;Ljava/lang/Class;)Lcom/metacontent/cobblenav/client/settings/Settings;", "DIRECTORY", "Ljava/lang/String;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "cobblenav-common"})
public final class ClientSettingsDataManager {
    @NotNull
    public static final ClientSettingsDataManager INSTANCE = new ClientSettingsDataManager();
    @NotNull
    public static final String DIRECTORY = "cobblenav/settings/";
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter((Type)((Object)IntRange.class), (Object)IntRangeAdapter.INSTANCE).create();

    private ClientSettingsDataManager() {
    }

    public final Gson getGSON() {
        return GSON;
    }

    private final String toPath(String $this$toPath) {
        return DIRECTORY + $this$toPath + ".json";
    }

    public final <T extends Settings<T>> void save(@NotNull T settings) {
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        File file = new File(this.toPath(settings.getName()));
        try {
            FileWriter fileWriter = new FileWriter(file);
            GSON.toJson(settings, (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            Cobblenav.INSTANCE.getLOGGER().error(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public final <T extends Settings<T>> Settings<T> load(@NotNull String name, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        File file = new File(this.toPath(name));
        try {
            FileReader fileReader;
            Settings settings;
            file.getParentFile().mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            if ((settings = (Settings)GSON.fromJson((Reader)(fileReader = new FileReader(file)), clazz)) == null) {
                T t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
                settings = (Settings)t;
            }
            return settings;
        }
        catch (Exception e) {
            Cobblenav.INSTANCE.getLOGGER().error(e.getMessage(), (Throwable)e);
            T t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
            return (Settings)t;
        }
    }
}

