/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.util;

import com.cobblemon.mod.common.api.spawning.WorldSlice;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningArea;
import com.cobblemon.mod.common.api.tags.CobblemonBlockTags;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/metacontent/cobblenav/util/PokenavSpawningProspector;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;", "area", "Lcom/cobblemon/mod/common/api/spawning/WorldSlice;", "prospect", "(Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;)Lcom/cobblemon/mod/common/api/spawning/WorldSlice;", "cobblenav-common"})
public final class PokenavSpawningProspector {
    @NotNull
    public static final PokenavSpawningProspector INSTANCE = new PokenavSpawningProspector();

    private PokenavSpawningProspector() {
    }

    @Nullable
    public final WorldSlice prospect(@NotNull SpawningArea area) {
        int n;
        int n2;
        WorldSlice.BlockData[][][] blockDataArrayArray;
        int n3;
        int n4;
        int difference;
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        ServerLevel world = area.getWorld();
        int baseY = area.getBaseY();
        int height = area.getHeight();
        if (baseY < world.getMinBuildHeight()) {
            difference = world.getMinBuildHeight() - baseY;
            baseY += difference;
            if ((height -= difference) < 1) {
                return null;
            }
        }
        if (baseY + height >= world.getMaxBuildHeight() && (height -= (difference = baseY + height - 1 - world.getMaxBuildHeight())) < 1) {
            return null;
        }
        BlockState defaultState = Blocks.STONE.defaultBlockState();
        Intrinsics.checkNotNull((Object)defaultState);
        WorldSlice.BlockData defaultBlockData = new WorldSlice.BlockData(defaultState, 0, 0);
        int n5 = area.getLength();
        WorldSlice.BlockData[][][] blockDataArrayArray2 = new WorldSlice.BlockData[n5][][];
        for (int i = 0; i < n5; ++i) {
            int n6 = i;
            n4 = height;
            WorldSlice.BlockData[][] blockDataArrayArray3 = new WorldSlice.BlockData[n4][];
            n3 = n6;
            blockDataArrayArray = blockDataArrayArray2;
            for (n2 = 0; n2 < n4; ++n2) {
                int n7 = n2;
                n = 0;
                int n8 = area.getWidth();
                WorldSlice.BlockData[] blockDataArray = new WorldSlice.BlockData[n8];
                int n9 = n7;
                WorldSlice.BlockData[][] blockDataArrayArray4 = blockDataArrayArray3;
                while (n < n8) {
                    int n10 = n++;
                    blockDataArray[n10] = defaultBlockData;
                }
                blockDataArrayArray4[n9] = blockDataArray;
            }
            blockDataArrayArray[n3] = blockDataArrayArray3;
        }
        WorldSlice.BlockData[][][] blocks = blockDataArrayArray2;
        int n11 = area.getLength();
        Integer[][] integerArray = new Integer[n11][];
        for (n5 = 0; n5 < n11; ++n5) {
            n2 = n5;
            n4 = 0;
            int n12 = area.getWidth();
            Integer[] integerArray2 = new Integer[n12];
            n3 = n2;
            blockDataArrayArray = integerArray;
            while (n4 < n12) {
                n = n4++;
                integerArray2[n] = world.getMaxBuildHeight();
            }
            blockDataArrayArray[n3] = integerArray2;
        }
        Integer[][] skyLevel = integerArray;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Map chunks = new LinkedHashMap();
        IntProgression yRange = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)baseY, (int)(baseY + height))));
        LevelLightEngine lightingProvider = world.getLightEngine();
        int n13 = area.getBaseX() + area.getLength();
        for (int x = area.getBaseX(); x < n13; ++x) {
            n = area.getBaseZ() + area.getWidth();
            block6: for (int z = area.getBaseZ(); z < n; ++z) {
                if (chunks.computeIfAbsent(new Pair((Object)SectionPos.blockToSectionCoord((int)x), (Object)SectionPos.blockToSectionCoord((int)z)), arg_0 -> PokenavSpawningProspector.prospect$lambda$1(arg_0 -> PokenavSpawningProspector.prospect$lambda$0(world, arg_0), arg_0)) == null) continue;
                boolean canSeeSky = world.canSeeSkyFromBelowWater((BlockPos)pos.set(x, yRange.getFirst(), z));
                int y = yRange.getFirst();
                int n14 = yRange.getLast();
                int n15 = yRange.getStep();
                if ((n15 <= 0 || y > n14) && (n15 >= 0 || n14 > y)) continue;
                while (true) {
                    ChunkAccess query;
                    int skyLight = lightingProvider.getLayerListener(LightLayer.SKY).getLightValue((BlockPos)pos.set(x, y, z));
                    BlockState state = query.getBlockState((BlockPos)pos.set(x, y, z));
                    WorldSlice.BlockData[] blockDataArray = blocks[x - area.getBaseX()][y - baseY];
                    int n16 = z - area.getBaseZ();
                    Intrinsics.checkNotNull((Object)state);
                    blockDataArray[n16] = new WorldSlice.BlockData(state, world.getMaxLocalRawBrightness((BlockPos)pos), skyLight);
                    if (canSeeSky) {
                        skyLevel[x - area.getBaseX()][z - area.getBaseZ()] = y;
                    }
                    if (state.getFluidState().isEmpty() && !state.is(CobblemonBlockTags.SEES_SKY)) {
                        canSeeSky = false;
                    }
                    if (y == n14) continue block6;
                    y += n15;
                }
            }
        }
        return new WorldSlice(area.getCause(), world, area.getBaseX(), baseY, area.getBaseZ(), (WorldSlice.BlockData[][][])blocks, skyLevel, CollectionsKt.emptyList());
    }

    private static final ChunkAccess prospect$lambda$0(ServerLevel $world, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $world.getChunk(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue(), ChunkStatus.FULL, false);
    }

    private static final ChunkAccess prospect$lambda$1(Function1 $tmp0, Object p0) {
        return (ChunkAccess)$tmp0.invoke(p0);
    }
}

