/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.serialization.MapCodec;
import net.mehvahdjukaar.amendments.common.block.AbstractCandleSkullBlock;
import net.mehvahdjukaar.amendments.common.tile.CandleSkullBlockTile;
import net.mehvahdjukaar.moonlight.api.block.IRecolorable;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FloorCandleSkullBlock
extends AbstractCandleSkullBlock
implements IRecolorable {
    public static final MapCodec<FloorCandleSkullBlock> CODEC = FloorCandleSkullBlock.simpleCodec(FloorCandleSkullBlock::new);
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;

    public FloorCandleSkullBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends FloorCandleSkullBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{ROTATION});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    public boolean tryRecolor(Level level, BlockPos blockPos, BlockState blockState, @Nullable DyeColor dyeColor) {
        Block otherCandle;
        CandleSkullBlockTile tile;
        BlockState c;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CandleSkullBlockTile && !(c = (tile = (CandleSkullBlockTile)blockEntity).getCandle()).isAir() && (otherCandle = BlocksColorAPI.changeColor((Block)c.getBlock(), (DyeColor)dyeColor)) != null && !c.is(otherCandle)) {
            tile.setCandle(otherCandle.withPropertiesOf(c));
            tile.setChanged();
            return true;
        }
        return false;
    }

    public boolean isDefaultColor(Level level, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity;
            BlockState c = tile.getCandle();
            return BlocksColorAPI.isDefaultColor((Block)c.getBlock());
        }
        return false;
    }
}

