/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model.assembly.neoforge;

import com.copycatsplus.copycats.foundation.copycat.model.assembly.AssemblyTransform;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.CopycatRenderContext;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.MutableAABB;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.MutableCullFace;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.MutableQuad;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.MutableUV;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.MutableVec3;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.MutableVertex;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.quad.QuadAutoCull;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.quad.QuadTransform;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateTextureAtlasSprite;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@ApiStatus.Internal
public class CopycatRenderContextNeoForge
extends CopycatRenderContext.Base<List<CopycatBakedQuad>, List<CopycatBakedQuad>> {
    public CopycatRenderContextNeoForge(List<CopycatBakedQuad> source, List<CopycatBakedQuad> destination, String property) {
        super(source, destination, property);
    }

    @Override
    public void assemblePiece(AssemblyTransform assemblyTransform, MutableVec3 offset, MutableAABB select, MutableCullFace cull) {
        assemblyTransform.apply(select);
        assemblyTransform.apply(offset);
        assemblyTransform.apply(cull);
        AABB aabb = select.toAABB();
        Vec3 vec3 = offset.toVec3().subtract(select.minX, select.minY, select.minZ);
        for (CopycatBakedQuad quad : (List)this.source()) {
            if (cull.isCulled(quad.getDirection())) continue;
            CopycatRenderContextNeoForge.assembleQuad(quad, (List)this.destination(), this.key(), aabb, vec3, assemblyTransform, new QuadTransform[0]);
        }
    }

    @Override
    public void assemblePiece(AssemblyTransform assemblyTransform, MutableVec3 offset, MutableAABB select, MutableCullFace cull, QuadTransform ... transforms) {
        assemblyTransform.apply(select);
        assemblyTransform.apply(offset);
        assemblyTransform.apply(cull);
        AABB aabb = select.toAABB();
        Vec3 vec3 = offset.toVec3().subtract(select.minX, select.minY, select.minZ);
        for (CopycatBakedQuad quad : (List)this.source()) {
            if (cull.isCulled(quad.getDirection())) continue;
            CopycatRenderContextNeoForge.assembleQuad(quad, (List)this.destination(), this.key(), aabb, vec3, assemblyTransform, transforms);
        }
    }

    @Override
    public void assembleAll() {
        for (CopycatBakedQuad quad : (List)this.source()) {
            CopycatRenderContextNeoForge.assembleQuad(quad, (List)this.destination());
        }
    }

    private static void assembleQuad(CopycatBakedQuad src, List<CopycatBakedQuad> dest) {
        dest.add(src);
    }

    @Override
    public void assembleRaw(AABB crop, Vec3 move) {
        for (CopycatBakedQuad quad : (List)this.source()) {
            CopycatRenderContextNeoForge.assembleQuad(quad, (List)this.destination(), this.key(), crop, move, AssemblyTransform.IDENTITY, new QuadTransform[0]);
        }
    }

    @Override
    public void assembleRaw(AABB crop, Vec3 move, QuadTransform ... transforms) {
        for (CopycatBakedQuad quad : (List)this.source()) {
            CopycatRenderContextNeoForge.assembleQuad(quad, (List)this.destination(), this.key(), crop, move, AssemblyTransform.IDENTITY, transforms);
        }
    }

    private static void assembleQuad(CopycatBakedQuad src, List<CopycatBakedQuad> dest, String key, AABB crop, Vec3 move, AssemblyTransform assemblyTransform, QuadTransform ... transforms) {
        int[] vertices = BakedModelHelper.cropAndMove((int[])src.getVertices(), (TextureAtlasSprite)src.getSprite(), (AABB)crop, (Vec3)move);
        MutableQuad mutableQuad = CopycatRenderContextNeoForge.getMutableQuad(vertices, src.cullFace);
        assemblyTransform.apply(mutableQuad);
        mutableQuad.undoMutate();
        for (QuadTransform transform : transforms) {
            if (transform.transformQuad(mutableQuad, src.getSprite())) continue;
            return;
        }
        if (!mutableQuad.disableFinalAutoCull && !QuadAutoCull.BLOCK.transformQuad(mutableQuad, src.getSprite())) {
            return;
        }
        mutableQuad.mutate();
        for (int i = 0; i < 4; ++i) {
            BakedQuadHelper.setXYZ((int[])vertices, (int)i, (Vec3)mutableQuad.vertices.get((int)i).xyz.toVec3());
            BakedQuadHelper.setU((int[])vertices, (int)i, (float)mutableQuad.vertices.get((int)i).uv.u);
            BakedQuadHelper.setV((int[])vertices, (int)i, (float)mutableQuad.vertices.get((int)i).uv.v);
        }
        dest.add(new CopycatBakedQuad(vertices, src.getTintIndex(), mutableQuad.computeLightFace(), src.getSprite(), src.isShade(), mutableQuad.cullFace, key));
    }

    public static MutableQuad getMutableQuad(int[] vertexData, @Nullable Direction cullFace) {
        ArrayList<MutableVertex> vertices = new ArrayList<MutableVertex>(4);
        for (int i = 0; i < 4; ++i) {
            MutableVec3 xyz = new MutableVec3((Position)BakedQuadHelper.getXYZ((int[])vertexData, (int)i));
            MutableUV uv = new MutableUV(BakedQuadHelper.getU((int[])vertexData, (int)i), BakedQuadHelper.getV((int[])vertexData, (int)i));
            vertices.add(new MutableVertex(xyz, uv));
        }
        return new MutableQuad(vertices, cullFace);
    }

    public static class CopycatBakedQuad
    extends BakedQuad {
        @Nullable
        public Direction cullFace;
        public final String property;

        public CopycatBakedQuad(int[] vertices, int tintIndex, Direction direction, TextureAtlasSprite sprite, boolean shade, @Nullable Direction cullFace, String property) {
            super(vertices, tintIndex, direction, sprite, shade);
            this.cullFace = cullFace;
            this.property = property;
        }

        public CopycatBakedQuad(BakedQuad quad, @Nullable Direction cullFace, String property) {
            this(quad.getVertices(), quad.getTintIndex(), quad.getDirection(), quad.getSprite(), quad.isShade(), cullFace, property);
        }

        public BakedQuad toBakedQuad() {
            return new BakedQuad(this.getVertices(), this.getTintIndex(), this.getDirection(), (TextureAtlasSprite)new MultiStateTextureAtlasSprite(this.property, this.getSprite()), this.isShade());
        }
    }
}

